/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.visit.VisitEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;

public class EditVisitTask
extends AbstractTask {
    private VisitEditorDialog dialog;

    public void start(TaskContext context) {
        Act event = (Act)context.getObject("act.patientClinicalEvent");
        FinancialAct invoice = (FinancialAct)context.getObject("act.customerAccountChargesInvoice");
        if (event != null && invoice != null) {
            this.edit(event, invoice, context);
        } else {
            this.notifyCancelled();
        }
    }

    public VisitEditorDialog getVisitDialog() {
        return this.dialog;
    }

    protected void edit(Act event, FinancialAct invoice, TaskContext context) {
        Party customer;
        IMObjectBean eventBean = this.getBean((IMObject)event);
        IMObjectBean invoiceBean = this.getBean((IMObject)invoice);
        User clinician = (User)IMObjectHelper.getObject((Reference)eventBean.getTargetRef("clinician"), (Context)context);
        if (clinician == null && context.getClinician() != null) {
            eventBean.setTarget("clinician", (IMObject)context.getClinician());
            eventBean.save();
        }
        if ((customer = (Party)IMObjectHelper.getObject((Reference)invoiceBean.getTargetRef("customer"), (Context)context)) == null) {
            customer = context.getCustomer();
        }
        Party patient = (Party)IMObjectHelper.getObject((Reference)eventBean.getTargetRef("patient"), (Context)context);
        if (customer != null && patient != null) {
            HelpContext help = context.getHelpContext().topic("visit");
            VisitEditor editor = this.createVisitEditor(event, invoice, customer, patient, context, help);
            String title = Messages.get((String)"workflow.visit.edit.title");
            this.dialog = this.createDialog(title, editor, help);
            this.dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    EditVisitTask.this.notifyCompleted();
                }

                public void onCancel() {
                    EditVisitTask.this.notifyCancelled();
                }

                protected void onAction(PopupDialog dialog) {
                    EditVisitTask.this.dialog = null;
                    super.onAction(dialog);
                }
            });
            this.dialog.show();
        } else {
            this.notifyCancelled();
        }
    }

    protected VisitEditor createVisitEditor(Act event, FinancialAct invoice, Party customer, Party patient, TaskContext context, HelpContext help) {
        return new VisitEditor(customer, patient, event, invoice, (Context)context, help);
    }

    protected VisitEditorDialog createDialog(String title, VisitEditor editor, HelpContext help) {
        return new VisitEditorDialog(title, editor, help);
    }
}

