/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import java.util.Date;
import java.util.Objects;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.resource.i18n.Messages;

public class ClinicalEventFactory {
    private final MedicalRecordRules recordRules;
    private final IArchetypeService service;
    private final AppointmentRules appointmentRules;

    public ClinicalEventFactory(IArchetypeService service, MedicalRecordRules recordRules, AppointmentRules appointmentRules) {
        this.service = service;
        this.recordRules = recordRules;
        this.appointmentRules = appointmentRules;
    }

    public Act getEvent(Date date, Party patient, User clinician, Act appointment, String reason, Party location, boolean newEvent) {
        Act event;
        if (!newEvent && appointment != null) {
            IMObjectBean bean = this.service.getBean((IMObject)appointment);
            event = (Act)bean.getTarget("event", Act.class);
            if (event == null) {
                if (this.appointmentRules.isBoardingAppointment(appointment)) {
                    throw new IllegalStateException(Messages.format((String)"workflow.checkin.visit.novisit", (Object[])new Object[]{patient.getName(), appointment.getActivityStartTime()}));
                }
                event = this.getEvent(date, patient, (Entity)clinician, location);
            }
        } else {
            event = this.getEvent(date, patient, (Entity)clinician, location);
        }
        if (event != null) {
            if (event.isNew()) {
                this.populate(event, reason);
            } else if (newEvent) {
                if (!"COMPLETED".equals(event.getStatus())) {
                    if (appointment == null || !this.hasEvent(appointment, event)) {
                        throw new IllegalStateException(Messages.format((String)"workflow.checkin.visit.exists", (Object[])new Object[]{patient.getName(), event.getActivityStartTime()}));
                    }
                } else {
                    event = this.recordRules.createEvent(patient, date, (Entity)clinician, location);
                    this.populate(event, reason);
                }
            }
        }
        return event;
    }

    protected Act getEvent(Date date, Party patient, Entity clinician, Party location) {
        return this.recordRules.getEventForAddition(patient, date, clinician, location);
    }

    protected void populate(Act event, String reason) {
        event.setStatus("IN_PROGRESS");
        event.setReason(reason);
    }

    private boolean hasEvent(Act appointment, Act event) {
        IMObjectBean bean = this.service.getBean((IMObject)appointment);
        Reference eventRef = bean.getTargetRef("event");
        return Objects.equals(eventRef, event.getObjectReference());
    }
}

