/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.user;

import echopointng.LabelEx;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.PasswordField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.OpenVPMSApp;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PasswordDialog
extends ModalDialog {
    private final OpenVPMSApp app;
    private final String message;
    private final PasswordEncoder encoder;
    private final PasswordField password;
    private Column container;
    private int attempts = 0;
    private static final int MAX_ATTEMPTS = 5;

    public PasswordDialog() {
        this(OpenVPMSApp.getInstance());
    }

    public PasswordDialog(OpenVPMSApp app) {
        this(app, Messages.get((String)"password.message"), OK_CANCEL);
    }

    public PasswordDialog(OpenVPMSApp app, String message, String[] buttons) {
        super(Messages.get((String)"password.title"), buttons, null);
        this.app = app;
        this.message = message;
        this.password = TextComponentFactory.createPassword((int)20);
        this.password.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PasswordDialog.this.onOK();
            }
        });
        this.encoder = (PasswordEncoder)app.getApplicationContext().getBean(PasswordEncoder.class);
        this.resize("PasswordDialog.size");
    }

    public void userClose() {
        if (this.getAction() == null) {
            this.setAction("cancel");
        }
        super.userClose();
    }

    protected void onOK() {
        UserDetails user = this.getUser();
        if (user != null) {
            if (this.checkPassword(user)) {
                super.onOK();
            } else if (++this.attempts < 5) {
                this.password.setText(null);
                if (this.container.getComponentCount() == 3) {
                    this.container.add((Component)LabelFactory.create((String)"password.error", (String)"login.error"));
                }
            } else {
                this.app.logout();
            }
        }
    }

    protected void doLayout() {
        Label loggedIn = LabelFactory.create((String)"password.loggedin");
        Label name = LabelFactory.create(null, (String)"bold");
        UserDetails user = this.getUser();
        if (user != null) {
            name.setText(user.getUsername());
        }
        LabelEx space = new LabelEx(new XhtmlFragment("<div>&#160;</div>"));
        this.container = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{RowFactory.create((Component[])new Component[]{loggedIn, space, name}), LabelFactory.text((String)this.message), this.password});
        Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{this.container});
        this.getLayout().add((Component)row);
    }

    private boolean checkPassword(UserDetails user) {
        String text = StringUtils.trimToNull((String)this.password.getText());
        return text != null && this.encoder.matches((CharSequence)text, user.getPassword());
    }

    private UserDetails getUser() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return principal instanceof UserDetails ? (UserDetails)principal : null;
    }
}

