/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.function.Consumer;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.workspace.ActPoster;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.supplier.SupplierHelper;
import org.openvpms.web.workspace.supplier.order.OrderActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupplierOrderPoster
extends ActPoster<FinancialAct> {
    private final Context context;
    private static final Logger log = LoggerFactory.getLogger(SupplierOrderPoster.class);

    public SupplierOrderPoster(FinancialAct act, OrderActions actions, Context context, HelpContext help) {
        super((Act)act, (ActActions)actions, help);
        this.context = context;
    }

    protected void confirmPost(FinancialAct act, HelpContext help, Consumer<ActionStatus> listener) {
        User user;
        UserRules userRules;
        PracticeRules practiceRules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
        OrderRules orderRules = SupplierHelper.createOrderRules(this.context.getPractice());
        boolean restricted = false;
        if (practiceRules.isOrderingRestricted(this.context.getPractice()) && !(userRules = (UserRules)ServiceHelper.getBean(UserRules.class)).isClinician(user = this.context.getUser()) && orderRules.hasRestrictedProducts((Act)act)) {
            log.warn("A user has attempted to finalise a restricted order. User={}, order={}", (Object)user.getUsername(), (Object)act.getId());
            restricted = true;
        }
        if (restricted) {
            ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().titleKey("supplier.order.restricted.title", new Object[0])).messageKey("supplier.order.restricted.message", new Object[0])).ok(() -> listener.accept(ActionStatus.success()))).show();
        } else {
            super.confirmPost((Act)act, help, listener);
        }
    }
}

