/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.workspace.supplier.SupplierHelper;

public class OrderProgressBarProcessor
extends ProgressBarProcessor<LocationSupplier> {
    private final OrderRules rules;
    private final boolean belowIdealQuantity;
    private int orders;

    public OrderProgressBarProcessor(Party practice, List<IMObject> stockLocations, List<IMObject> suppliers, boolean belowIdealQuantity, String title) {
        super((Iterable)new LocationSuppliers(stockLocations, suppliers), stockLocations.size() * suppliers.size(), title);
        this.belowIdealQuantity = belowIdealQuantity;
        this.rules = SupplierHelper.createOrderRules(practice);
    }

    public int getOrders() {
        return this.orders;
    }

    protected void process(LocationSupplier pair) {
        List order = this.rules.createOrder(pair.getSupplier(), pair.getStockLocation(), this.belowIdealQuantity);
        if (!order.isEmpty()) {
            if (!SaveHelper.save((Collection)order)) {
                this.cancel();
            } else {
                ++this.orders;
            }
        }
        if (!this.isSuspended()) {
            this.processCompleted(pair);
        }
    }

    protected void notifyError(Throwable exception) {
        super.notifyError(exception);
        this.notifyCompleted();
    }

    static class LocationSuppliers
    implements Iterable<LocationSupplier> {
        private final List<IMObject> stockLocations;
        private final List<IMObject> suppliers;

        public LocationSuppliers(List<IMObject> stockLocations, List<IMObject> suppliers) {
            this.stockLocations = stockLocations;
            this.suppliers = suppliers;
        }

        @Override
        public Iterator<LocationSupplier> iterator() {
            return new Iterator<LocationSupplier>(){
                int stockIndex;
                int supplierIndex;

                @Override
                public boolean hasNext() {
                    return this.stockIndex < stockLocations.size();
                }

                @Override
                public LocationSupplier next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    LocationSupplier result = new LocationSupplier((Party)stockLocations.get(this.stockIndex), (Party)suppliers.get(this.supplierIndex));
                    if (this.supplierIndex < suppliers.size() - 1) {
                        ++this.supplierIndex;
                    } else {
                        this.supplierIndex = 0;
                        ++this.stockIndex;
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class LocationSupplier {
        private final Party stockLocation;
        private final Party supplier;

        public LocationSupplier(Party stockLocation, Party supplier) {
            this.stockLocation = stockLocation;
            this.supplier = supplier;
        }

        public Party getStockLocation() {
            return this.stockLocation;
        }

        public Party getSupplier() {
            return this.supplier;
        }
    }
}

