/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.customer.StockOnHand;

public class OrderItemTableModel
extends DescriptorTableModel<IMObject> {
    private final Reference stockLocation;
    private final StockOnHand stock;
    private int onHandIndex = -1;

    public OrderItemTableModel(Reference stockLocation, StockOnHand stock, LayoutContext context) {
        super(context);
        this.stockLocation = stockLocation;
        this.stock = stock;
        this.setTableColumnModel(this.createColumnModel(new String[]{"act.supplierOrderItem"}, context));
    }

    protected Object getValue(IMObject object, TableColumn column, int row) {
        if (column.getModelIndex() == this.onHandIndex) {
            return this.getOnHand(object);
        }
        return super.getValue(object, column, row);
    }

    protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
        TableColumnModel model = super.createColumnModel(shortNames, context);
        DescriptorTableColumn quantity = this.getColumn(model, "quantity");
        this.onHandIndex = this.getNextModelIndex(model);
        TableColumn onHand = new TableColumn(this.onHandIndex);
        onHand.setHeaderValue((Object)Messages.get((String)"product.stock.onhand"));
        this.addColumnAfter(onHand, quantity.getModelIndex(), model);
        return model;
    }

    private Component getOnHand(IMObject object) {
        Label result = null;
        IMObjectBean bean = this.getBean(object);
        Reference product = bean.getTargetRef("product");
        if (product != null) {
            BigDecimal value = this.stock.getStock(product, this.stockLocation);
            result = TableHelper.rightAlign((String)NumberFormatter.format((Number)value));
        }
        return result;
    }
}

