/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.math.BigDecimal;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.ProductOrder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.supplier.SupplierStockItemEditor;
import org.openvpms.web.workspace.supplier.order.OrderEditContext;
import org.openvpms.web.workspace.supplier.order.ProductOnOrderDialog;

public class OrderItemEditor
extends SupplierStockItemEditor {
    private final boolean inProgress;
    private final boolean limitEditing;
    private final Reference stockLocation;
    private final OrderEditContext editContext;
    private final SimpleProperty onHand = new SimpleProperty("onHand", null, BigDecimal.class, Messages.get((String)"product.stock.onhand"), true);
    private boolean productSupplierReadOnly;
    private static final String QUANTITY = "quantity";
    private static final String RECEIVED_QUANTITY = "receivedQuantity";
    private static final String CANCELLED_QUANTITY = "cancelledQuantity";

    public OrderItemEditor(FinancialAct act, Act parent, LayoutContext context) {
        this(act, parent, new OrderEditContext(), context);
    }

    public OrderItemEditor(FinancialAct act, Act parent, OrderEditContext context, LayoutContext layoutContext) {
        super(act, parent, layoutContext);
        if (!act.isA("act.supplierOrderItem")) {
            throw new IllegalArgumentException("Invalid act type: " + act.getArchetype());
        }
        if (parent != null) {
            String status = parent.getStatus();
            this.inProgress = "IN_PROGRESS".equals(status);
            this.limitEditing = "POSTED".equals(status) || "ACCEPTED".equals(status) || "CANCELLED".equals(status);
            this.stockLocation = this.getStockLocationRef();
        } else {
            this.inProgress = true;
            this.limitEditing = false;
            this.stockLocation = null;
        }
        this.productSupplierReadOnly = this.getMatchingProductSupplier() != null;
        this.editContext = context;
        this.updateStockOnHand();
    }

    public BigDecimal getReceivedQuantity() {
        return (BigDecimal)this.getProperty(RECEIVED_QUANTITY).getValue();
    }

    public void setReceivedQuantity(BigDecimal quantity) {
        this.getProperty(RECEIVED_QUANTITY).setValue((Object)quantity);
    }

    public BigDecimal getCancelledQuantity() {
        return (BigDecimal)this.getProperty(CANCELLED_QUANTITY).getValue();
    }

    public void setCancelledQuantity(BigDecimal quantity) {
        this.getProperty(CANCELLED_QUANTITY).setValue((Object)quantity);
    }

    public boolean isRestrictedProduct() {
        Product product = this.getProduct();
        return product != null && this.getProductRules().isRestricted(product);
    }

    @Override
    protected void productModified(Product product) {
        super.productModified(product);
        if (this.changeLayoutRequired()) {
            this.onLayout();
        }
        this.updateStockOnHand();
        this.checkOrdered(product);
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = super.doValidation(validator);
        if (valid) {
            BigDecimal quantity = this.getQuantity();
            BigDecimal cancelled = this.getCancelledQuantity();
            if (cancelled.compareTo(quantity) > 0) {
                valid = false;
                Property property = this.getProperty(QUANTITY);
                String message = Messages.format((String)"supplier.order.invalidCancelledQuantity", (Object[])new Object[]{quantity, cancelled});
                ValidatorError error = new ValidatorError(property, message);
                validator.add((Modifiable)property, error);
            }
        }
        return valid;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    private boolean changeLayoutRequired() {
        boolean result = false;
        ProductSupplier current = this.getProductSupplier();
        if (this.productSupplierReadOnly && current == null) {
            this.productSupplierReadOnly = false;
            result = true;
        } else if (!this.productSupplierReadOnly && current != null) {
            this.productSupplierReadOnly = true;
            result = true;
        }
        return result;
    }

    private void checkOrdered(Product product) {
        List<ProductOrder> productOrders;
        if (product != null && this.stockLocation != null && !(productOrders = this.editContext.getOrders(product.getObjectReference(), this.stockLocation)).isEmpty()) {
            ProductOnOrderDialog dialog = new ProductOnOrderDialog(product, productOrders);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onNo() {
                    OrderItemEditor.this.setProduct(null);
                }
            });
            dialog.show();
        }
    }

    private void updateStockOnHand() {
        Reference product = this.getProductRef();
        if (product == null || this.stockLocation == null) {
            this.onHand.setValue(null);
        } else {
            BigDecimal stock = this.editContext.getStock().getStock(product, this.stockLocation);
            this.onHand.setValue((Object)stock);
        }
    }

    protected class LayoutStrategy
    extends AbstractLayoutStrategy {
        protected LayoutStrategy() {
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            if (OrderItemEditor.this.inProgress) {
                this.setArchetypeNodes(ArchetypeNodes.all().exclude(new String[]{OrderItemEditor.RECEIVED_QUANTITY, OrderItemEditor.CANCELLED_QUANTITY}));
            }
            if (OrderItemEditor.this.limitEditing || OrderItemEditor.this.productSupplierReadOnly) {
                MutablePropertySet set = new MutablePropertySet(properties);
                if (OrderItemEditor.this.limitEditing) {
                    for (Property property : set.getProperties()) {
                        if (property.isReadOnly() || property.getName().equals(OrderItemEditor.CANCELLED_QUANTITY)) continue;
                        set.setReadOnly(property.getName());
                    }
                } else {
                    this.markReadOnlyIfSet("reorderCode", set);
                    this.markReadOnlyIfSet("reorderDescription", set);
                    if (this.markReadOnlyIfNonZero("packageSize", set)) {
                        this.markReadOnlyIfSet("packageUnits", set);
                    }
                    this.markReadOnlyIfNonZero("listPrice", set);
                    this.markReadOnlyIfNonZero("unitPrice", set);
                }
                properties = set;
            }
            ComponentState quantity = this.createComponent(properties.get(OrderItemEditor.QUANTITY), object, context);
            ComponentState stockQuantity = this.createStockOnHand(context);
            Row onHand = RowFactory.create((String)"CellSpacing", (LayoutData)RowFactory.rightAlign(), (Component[])new Component[]{stockQuantity.getLabel(), stockQuantity.getComponent()});
            Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{quantity.getComponent(), onHand});
            this.addComponent(new ComponentState((Component)row, quantity.getProperty()));
            return super.apply(object, properties, parent, context);
        }

        private ComponentState createStockOnHand(LayoutContext context) {
            Component component = context.getComponentFactory().create((Property)OrderItemEditor.this.onHand);
            return new ComponentState(component, (Property)OrderItemEditor.this.onHand);
        }

        private void markReadOnlyIfSet(String name, MutablePropertySet properties) {
            Property property = properties.get(name);
            if (property != null && property.getValue() != null) {
                properties.setReadOnly(name);
            }
        }

        private boolean markReadOnlyIfNonZero(String name, MutablePropertySet properties) {
            Property property = properties.get(name);
            if (property != null && !MathRules.isZero((BigDecimal)property.getBigDecimal(BigDecimal.ZERO))) {
                properties.setReadOnly(name);
                return true;
            }
            return false;
        }
    }
}

