/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Button;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.component.business.service.scheduler.JobScheduler;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.esci.adapter.dispatcher.ESCIDispatcher;
import org.openvpms.esci.adapter.dispatcher.ErrorHandler;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.supplier.SupplierActCRUDWindow;
import org.openvpms.web.workspace.supplier.order.ESCIErrorHandler;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ESCISupplierCRUDWindow
extends SupplierActCRUDWindow<FinancialAct> {
    protected static final String CHECK_INBOX_ID = "checkInbox";
    private static final Log log = LogFactory.getLog(ESCISupplierCRUDWindow.class);

    public ESCISupplierCRUDWindow(Archetypes<FinancialAct> archetypes, ActActions<FinancialAct> operations, Context context, HelpContext help) {
        super(archetypes, operations, context, help);
    }

    protected Button createCheckInboxButton() {
        return ButtonFactory.create((String)CHECK_INBOX_ID, this::checkInbox);
    }

    protected void checkInbox() {
        ESCIErrorHandler handler = new ESCIErrorHandler();
        ESCIDispatcher dispatcher = (ESCIDispatcher)ServiceHelper.getBean(ESCIDispatcher.class);
        dispatcher.dispatch(true, (ErrorHandler)handler);
        if (handler.getErrors() != 0) {
            ErrorHelper.show((String)Messages.format((String)"supplier.esci.checkinbox.error", (Object[])new Object[]{handler.formatErrors()}));
        }
    }

    protected void scheduleCheckInbox(boolean delay) {
        try {
            String name = this.getESCIJobName();
            if (!StringUtils.isEmpty((CharSequence)name)) {
                String triggerName = "ESCIDispatcherAdhocTrigger";
                Scheduler scheduler = (Scheduler)ServiceHelper.getBean(Scheduler.class);
                scheduler.unscheduleJob(new TriggerKey(triggerName));
                TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(triggerName).forJob(name);
                if (delay) {
                    Date in30secs = new Date(System.currentTimeMillis() + 30000L);
                    builder.startAt(in30secs);
                }
                Trigger trigger = builder.build();
                scheduler.scheduleJob(trigger);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private String getESCIJobName() {
        String name = null;
        JobScheduler scheduler = (JobScheduler)ServiceHelper.getBean(JobScheduler.class);
        List jobs = scheduler.getJobs("entity.jobESCIInboxReader");
        if (!jobs.isEmpty()) {
            name = scheduler.getJobName((Entity)jobs.get(0));
        }
        return name;
    }
}

