/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.system.ServiceHelper;

public class OrderSelectionTableModel
extends DescriptorTableModel<FinancialAct> {
    private int selectedIndex;
    private int startTimeIndex;
    private int titleIndex;
    private List<CheckBox> selected = new ArrayList<CheckBox>();
    private OrderSelectionListener listener;

    public OrderSelectionTableModel(LayoutContext context) {
        super(new String[]{"act.supplierOrderItem"}, context);
    }

    public void setObjects(List<FinancialAct> objects) {
        super.setObjects(objects);
        this.selected = new ArrayList<CheckBox>(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            this.selected.add(new Toggle(i));
        }
    }

    public void setSelected(int index, boolean selected) {
        this.selected.get(index).setSelected(selected);
    }

    public int getSelectionColumnIndex() {
        return this.selectedIndex;
    }

    public List<FinancialAct> getSelected() {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        List acts = this.getObjects();
        for (int i = 0; i < this.selected.size(); ++i) {
            CheckBox box = this.selected.get(i);
            if (!box.isSelected()) continue;
            result.add((FinancialAct)acts.get(i));
        }
        return result;
    }

    public void setSelectionListener(OrderSelectionListener listener) {
        this.listener = listener;
    }

    protected Object getValue(FinancialAct object, TableColumn column, int row) {
        if (column.getModelIndex() == this.selectedIndex) {
            return this.selected.get(row);
        }
        return super.getValue((IMObject)object, column, row);
    }

    protected Object getValue(FinancialAct object, DescriptorTableColumn column, int row) {
        boolean orderColumn;
        Object result = null;
        int index = column.getModelIndex();
        boolean bl = orderColumn = index == this.startTimeIndex || index == this.titleIndex;
        if (TypeHelper.isA((IMObject)object, (String)"act.supplierOrder")) {
            if (orderColumn) {
                result = super.getValue((IMObject)object, column, row);
            }
        } else if (!orderColumn) {
            result = super.getValue((IMObject)object, column, row);
        }
        return result;
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    protected TableColumnModel createColumnModel(List<org.openvpms.component.model.archetype.ArchetypeDescriptor> archetypes, LayoutContext context) {
        TableColumnModel model = super.createColumnModel(archetypes, context);
        TableColumn selected = new TableColumn(this.getNextModelIndex(model));
        this.selectedIndex = selected.getModelIndex();
        model.addColumn(selected);
        model.moveColumn(model.getColumnCount() - 1, 0);
        ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor("act.supplierOrder");
        if (archetype != null) {
            TableColumn startTime = this.addColumn((org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, "startTime", model);
            this.startTimeIndex = startTime.getModelIndex();
            model.moveColumn(model.getColumnCount() - 1, 1);
            TableColumn title = this.addColumn((org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, "title", model);
            this.titleIndex = title.getModelIndex();
            model.moveColumn(model.getColumnCount() - 1, 2);
        }
        return model;
    }

    private void onSelected(int row, boolean selected) {
        if (this.listener != null) {
            List acts = this.getObjects();
            FinancialAct act = (FinancialAct)acts.get(row);
            this.listener.onSelected(act, row, selected);
        }
    }

    private class Toggle
    extends CheckBox {
        public Toggle(final int row) {
            this.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    OrderSelectionTableModel.this.onSelected(row, Toggle.this.isSelected());
                }
            });
        }
    }

    public static interface OrderSelectionListener {
        public void onSelected(FinancialAct var1, int var2, boolean var3);
    }
}

