/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.act.ActLayoutStrategy;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.style.Styles;

public class DeliveryLayoutStrategy
extends ActLayoutStrategy {
    private static final String SUPPLIER_INVOICE_ID = "supplierInvoiceId";
    private static final String SUPPLIER_NOTES = "supplierNotes";

    public DeliveryLayoutStrategy() {
        this(null);
    }

    public DeliveryLayoutStrategy(IMObjectCollectionEditor editor) {
        super(editor);
        this.getArchetypeNodes().excludeIfEmpty(new String[]{SUPPLIER_INVOICE_ID});
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property supplierNotes = properties.get(SUPPLIER_NOTES);
        if (supplierNotes != null) {
            this.getArchetypeNodes().exclude(new String[]{SUPPLIER_NOTES});
            if (supplierNotes.getValue() != null) {
                this.addComponent(this.createMultiLineText(supplierNotes, 2, 10, Styles.FULL_WIDTH, context));
            }
        }
        return super.apply(object, properties, parent, context);
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentGrid grid = super.createGrid(object, properties, context);
        ComponentState supplierNotes = this.getComponent(SUPPLIER_NOTES);
        if (supplierNotes != null) {
            grid.add(supplierNotes, 2);
        }
        return grid;
    }
}

