/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import java.math.BigDecimal;
import java.util.Objects;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.supplier.SupplierActItemEditor;

public abstract class SupplierStockItemEditor
extends SupplierActItemEditor {
    protected static final String REORDER_CODE = "reorderCode";
    protected static final String REORDER_DESCRIPTION = "reorderDescription";
    protected static final String PACKAGE_SIZE = "packageSize";
    protected static final String PACKAGE_UNITS = "packageUnits";
    protected static final String LIST_PRICE = "listPrice";
    private final ProductRules productRules = (ProductRules)ServiceHelper.getBean(ProductRules.class);
    private static final String[] ORDER_DETAILS = new String[]{"reorderCode", "reorderDescription", "packageSize", "packageUnits", "unitPrice", "listPrice"};

    public SupplierStockItemEditor(FinancialAct act, Act parent, LayoutContext context) {
        super(act, parent, context);
    }

    public Party getSupplier() {
        IMObjectBean bean = this.getBean(this.getParent());
        return (Party)this.getObject(bean.getTargetRef("supplier"));
    }

    public Party getStockLocation() {
        return (Party)this.getObject(this.getStockLocationRef());
    }

    public Reference getStockLocationRef() {
        IMObjectBean bean = this.getBean(this.getParent());
        return bean.getTargetRef("stockLocation");
    }

    public void setStockLocation(Party location) {
        ProductParticipationEditor editor = this.getProductEditor();
        if (editor != null) {
            editor.setStockLocation(location);
        }
    }

    public String getReorderCode() {
        return (String)this.getProperty(REORDER_CODE).getValue();
    }

    public void setReorderCode(String reorderCode) {
        this.getProperty(REORDER_CODE).setValue((Object)reorderCode);
    }

    public String getPackageUnits() {
        return (String)this.getProperty(PACKAGE_UNITS).getValue();
    }

    public String getReorderDescription() {
        return (String)this.getProperty(REORDER_DESCRIPTION).getValue();
    }

    public void setReorderDescription(String description) {
        this.getProperty(REORDER_DESCRIPTION).setValue((Object)description);
    }

    public void setPackageSize(Integer packageSize) {
        this.getProperty(PACKAGE_SIZE).setValue((Object)packageSize);
    }

    public int getPackageSize() {
        Integer value = (Integer)this.getProperty(PACKAGE_SIZE).getValue();
        return value != null ? value : 0;
    }

    public void setPackageUnits(String packageUnits) {
        this.getProperty(PACKAGE_UNITS).setValue((Object)packageUnits);
    }

    public void setListPrice(BigDecimal price) {
        this.getProperty(LIST_PRICE).setValue((Object)price);
    }

    public BigDecimal getListPrice() {
        return (BigDecimal)this.getProperty(LIST_PRICE).getValue();
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        ProductParticipationEditor productEditor = this.getProductEditor();
        if (productEditor != null) {
            productEditor.setSupplier(this.getSupplier());
            productEditor.setStockLocation(this.getStockLocation());
        }
    }

    protected void productModified(Product product) {
        ProductSupplier ps = this.getProductSupplier();
        if (ps != null) {
            this.setReorderCode(ps.getReorderCode());
            this.setReorderDescription(ps.getReorderDescription());
            this.setPackageSize(ps.getPackageSize());
            this.setPackageUnits(ps.getPackageUnits());
            this.setListPrice(ps.getListPrice());
            this.setUnitPrice(ps.getNettPrice());
        } else {
            this.setReorderCode(null);
            this.setReorderDescription(null);
            this.setPackageSize(null);
            this.setPackageUnits(null);
            this.setListPrice(null);
            this.setUnitPrice(null);
        }
        this.notifyProductListener(product);
    }

    protected void doSave() {
        Act object = this.getObject();
        if (!object.isA("act.supplierDeliveryItem") && this.orderDetailsChanged()) {
            Product product;
            Party supplier = this.getSupplier();
            Reference productRef = this.getProductRef();
            Product product2 = product = productRef != null ? (Product)this.getService().get(productRef, Product.class) : null;
            if (supplier != null && product != null) {
                this.getLayoutContext().getCache().add((IMObject)product);
                this.checkProductSupplier(product, supplier);
            }
        }
        super.doSave();
    }

    protected ProductSupplier getProductSupplier() {
        ProductParticipationEditor editor = this.getProductEditor();
        return editor != null ? editor.getProductSupplier() : null;
    }

    protected ProductSupplier getMatchingProductSupplier() {
        String units;
        int size;
        String reorderCode;
        ProductSupplier ps;
        ProductSupplier result = null;
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        if (product != null && supplier != null && (ps = this.productRules.getProductSupplier(product, supplier, reorderCode = this.getReorderCode(), size = this.getPackageSize(), units = this.getPackageUnits())) != null) {
            String reorderDesc = this.getReorderDescription();
            BigDecimal listPrice = this.getListPrice();
            BigDecimal nettPrice = this.getUnitPrice();
            if (size == ps.getPackageSize() && Objects.equals(units, ps.getPackageUnits()) && MathRules.equals((BigDecimal)listPrice, (BigDecimal)ps.getListPrice()) && MathRules.equals((BigDecimal)nettPrice, (BigDecimal)ps.getNettPrice()) && Objects.equals(ps.getReorderCode(), reorderCode) && Objects.equals(ps.getReorderDescription(), reorderDesc)) {
                result = ps;
            }
        }
        return result;
    }

    protected ProductRules getProductRules() {
        return this.productRules;
    }

    private boolean orderDetailsChanged() {
        for (String name : ORDER_DETAILS) {
            if (!this.getProperty(name).isModified()) continue;
            return true;
        }
        return false;
    }

    private void checkProductSupplier(Product product, Party supplier) {
        ProductSupplier ps = this.getProductSupplier();
        String reorderCode = this.getReorderCode();
        int size = this.getPackageSize();
        String units = this.getPackageUnits();
        if (ps == null) {
            ps = this.productRules.getProductSupplier(product, supplier, reorderCode, size, units);
        }
        boolean save = true;
        String reorderDesc = this.getReorderDescription();
        BigDecimal listPrice = this.getListPrice();
        BigDecimal unitPrice = this.getUnitPrice();
        if (ps == null) {
            ps = this.productRules.createProductSupplier(product, supplier);
            ps.setPackageSize(size);
            ps.setPackageUnits(units);
            ps.setReorderCode(reorderCode);
            ps.setReorderDescription(reorderDesc);
            ps.setListPrice(listPrice);
            ps.setNettPrice(unitPrice);
            if (this.productRules.getProductSuppliers(product, supplier).isEmpty()) {
                ps.setPreferred(true);
            }
        } else if (!(size == ps.getPackageSize() && Objects.equals(units, ps.getPackageUnits()) && MathRules.equals((BigDecimal)listPrice, (BigDecimal)ps.getListPrice()) && MathRules.equals((BigDecimal)unitPrice, (BigDecimal)ps.getNettPrice()) && Objects.equals(ps.getReorderCode(), reorderCode) && Objects.equals(ps.getReorderDescription(), reorderDesc))) {
            ps.setPackageSize(size);
            ps.setPackageUnits(units);
            ps.setReorderCode(reorderCode);
            ps.setReorderDescription(reorderDesc);
            ps.setListPrice(listPrice);
            ps.setNettPrice(unitPrice);
        } else {
            save = false;
        }
        if (save) {
            this.getService().save((IMObject)product);
        }
    }
}

