/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import java.util.ArrayList;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.workspace.product.stock.StockLocationSelector;
import org.openvpms.web.workspace.supplier.SupplierSelector;

public abstract class SupplierActQuery<T extends Act>
extends DateRangeActQuery<T> {
    private final IMObjectSelector<Party> supplier;
    private final IMObjectSelector<Party> stockLocation;

    public SupplierActQuery(String[] shortNames, ActStatuses statuses, Class<T> type, LayoutContext context) {
        super(null, "supplier", "participation.supplier", shortNames, statuses, type);
        this.supplier = new SupplierSelector(context, "party.supplierperson", "party.supplierorganisation");
        this.supplier.setListener((SelectorListener)new AbstractSelectorListener<Party>(){

            public void selected(Party object) {
                SupplierActQuery.this.setSupplier(object);
                SupplierActQuery.this.onQuery();
            }
        });
        this.stockLocation = new StockLocationSelector(context);
        this.stockLocation.setListener((SelectorListener)new AbstractSelectorListener<Party>(){

            public void selected(Party object) {
                SupplierActQuery.this.onQuery();
            }
        });
        this.setSupplier(context.getContext().getSupplier());
        this.setStockLocation((Party)this.stockLocation.getObject());
    }

    public void setSupplier(Party supplier) {
        this.setEntity((Entity)supplier);
        this.supplier.setObject((Object)supplier);
    }

    public Party getSupplier() {
        return (Party)this.supplier.getObject();
    }

    public void setStockLocation(Party stockLocation) {
        this.stockLocation.setObject((Object)stockLocation);
    }

    public Party getStockLocation() {
        return (Party)this.stockLocation.getObject();
    }

    protected ResultSet<T> createResultSet(SortConstraint[] sort) {
        ArrayList<ParticipantConstraint> list = new ArrayList<ParticipantConstraint>();
        ParticipantConstraint supplier = this.getParticipantConstraint();
        if (supplier != null) {
            list.add(supplier);
        }
        if (this.stockLocation.getObject() != null) {
            ParticipantConstraint location = new ParticipantConstraint("stockLocation", "participation.stockLocation", (Entity)this.stockLocation.getObject());
            list.add(location);
        }
        ParticipantConstraint[] participants = list.toArray(new ParticipantConstraint[0]);
        return this.createResultSet(participants, sort);
    }

    protected abstract ResultSet<T> createResultSet(ParticipantConstraint[] var1, SortConstraint[] var2);

    protected void addSupplierSelector(Component container) {
        this.addSelector(this.supplier, container);
    }

    protected void addStockLocationSelector(Component container) {
        this.addSelector(this.stockLocation, container);
    }

    private void addSelector(IMObjectSelector<Party> selector, Component container) {
        Label label = LabelFactory.create();
        label.setText(selector.getType());
        container.add((Component)label);
        container.add(selector.getComponent());
        this.getFocusGroup().add(selector.getComponent());
    }
}

