/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import java.util.Collection;
import java.util.List;
import org.openvpms.archetype.rules.finance.till.TillBalanceRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class TillBalanceUpdater {
    private final FinancialAct act;
    private final FinancialAct balance;
    private FinancialAct currentBalance;
    private final TillBalanceRules rules;
    private final IArchetypeService service;

    public TillBalanceUpdater(FinancialAct act, FinancialAct balance) {
        this.act = act;
        this.balance = balance;
        this.service = ServiceHelper.getArchetypeService();
        this.rules = new TillBalanceRules(this.service);
    }

    public boolean validate() {
        boolean result = true;
        this.currentBalance = (FinancialAct)IMObjectHelper.reload((IMObject)this.balance);
        if (this.currentBalance == null) {
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)this.balance, (ArchetypeService)this.service)}));
            result = false;
        } else if ("CLEARED".equals(this.currentBalance.getStatus())) {
            ErrorDialog.show((String)Messages.get((String)"till.adjustment.error.clearedBalance"));
            result = false;
        }
        return result;
    }

    public void prepare() {
        if (this.currentBalance == null) {
            throw new IllegalStateException("There is no current balance");
        }
        if ("CLEARED".equals(this.currentBalance.getStatus())) {
            throw new IllegalStateException("The current till balance has been cleared");
        }
        List changed = this.rules.addToBalance((Act)this.act, (Act)this.currentBalance);
        if (!changed.isEmpty()) {
            this.service.save((Collection)changed);
        }
    }

    public void commit() {
        this.rules.updateBalance(this.currentBalance);
    }
}

