/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import echopointng.DateChooser;
import echopointng.DateField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceSummaryQuery;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.list.AbstractListCellRenderer;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.lookup.ArchetypeLookupQuery;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.query.AbstractArchetypeQuery;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.util.ComponentHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.DateFieldFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class CustomerBalanceQuery
extends AbstractArchetypeQuery<ObjectSet> {
    private final Party practice;
    private final String[] balanceTypeItems;
    private LookupField accountType;
    private SelectField balanceType;
    private CheckBox excludeCredit;
    private DateField date;
    private Label periodFromLabel;
    private TextField periodFrom;
    private Label periodToLabel;
    private TextField periodTo;
    private TextField customerFrom;
    private TextField customerTo;
    private LocationSelectField locationSelector;
    private static final int ALL_BALANCE_INDEX = 0;
    private static final int OVERDUE_INDEX = 1;
    private static final int NON_OVERDUE_INDEX = 2;

    public CustomerBalanceQuery(Party practice) {
        super(new String[]{"party.customer*"}, ObjectSet.class);
        this.practice = practice;
        this.balanceTypeItems = new String[]{Messages.get((String)"reporting.statements.balancetype.all"), Messages.get((String)"reporting.statements.balancetype.overdue"), Messages.get((String)"reporting.statements.balancetype.nonOverdue")};
    }

    public void refreshAccountTypes() {
        if (this.accountType != null) {
            Lookup selected = this.accountType.getSelected();
            this.accountType.refresh();
            this.accountType.setSelected(selected);
        }
    }

    public boolean queryAllBalances() {
        return this.balanceType.getSelectedIndex() == 0;
    }

    public boolean queryOverduebalances() {
        return this.balanceType.getSelectedIndex() == 1;
    }

    public List<ObjectSet> getObjects() {
        ArrayList<ObjectSet> sets = new ArrayList<ObjectSet>();
        try {
            int selected = this.balanceType.getSelectedIndex();
            boolean nonOverdue = selected != 1;
            boolean overdue = selected != 2;
            int from = overdue ? this.getNumber(this.periodFrom) : -1;
            int to = overdue ? this.getNumber(this.periodTo) : -1;
            boolean credit = this.excludeCredit.isSelected();
            Location location = this.locationSelector.getSelected();
            CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            LookupService lookups = ServiceHelper.getLookupService();
            CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(this.getDate(), nonOverdue, from, to, credit, this.getAccountType(), this.getWildcardedText((TextComponent)this.customerFrom), this.getWildcardedText((TextComponent)this.customerTo), location, (IArchetypeService)service, lookups, rules);
            while (query.hasNext()) {
                sets.add(query.next());
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return sets;
    }

    public void setDate(Date date) {
        DateChooser chooser = this.date.getDateChooser();
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
        }
        chooser.setSelectedDate(calendar);
    }

    public Date getDate() {
        return this.date.getSelectedDate().getTime();
    }

    public Extent getHeight() {
        return this.getHeight(3);
    }

    protected void doLayout(Component container) {
        Grid grid = GridFactory.create((int)6);
        this.accountType = LookupFieldFactory.create((LookupQuery)new ArchetypeLookupQuery("lookup.customerAccountType"), (boolean)true);
        this.accountType.setSelected((Lookup)null);
        this.accountType.setCellRenderer((ListCellRenderer)LookupListCellRenderer.INSTANCE);
        Label accountTypeLabel = LabelFactory.create((String)"reporting.statements.accountType");
        this.date = DateFieldFactory.create();
        this.date.addPropertyChangeListener(event -> {});
        Label dateLabel = LabelFactory.create((String)"reporting.statements.date");
        this.balanceType = SelectFieldFactory.create((Object[])this.balanceTypeItems);
        this.balanceType.setCellRenderer((ListCellRenderer)new BalanceTypeListCellRenderer());
        this.balanceType.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                CustomerBalanceQuery.this.onBalanceTypeChanged();
            }
        });
        Label balanceTypeLabel = LabelFactory.create((String)"reporting.statements.balancetypes");
        grid.add((Component)accountTypeLabel);
        grid.add((Component)this.accountType);
        grid.add((Component)dateLabel);
        grid.add((Component)this.date);
        grid.add((Component)balanceTypeLabel);
        grid.add((Component)this.balanceType);
        this.periodFromLabel = LabelFactory.create((String)"reporting.statements.periodFrom");
        this.periodFrom = TextComponentFactory.create();
        this.periodFrom.addPropertyChangeListener(event -> {});
        this.periodToLabel = LabelFactory.create((String)"reporting.statements.periodTo");
        this.periodTo = TextComponentFactory.create();
        this.periodTo.addPropertyChangeListener(event -> {});
        this.excludeCredit = CheckBoxFactory.create((String)"reporting.statements.excludeCredit", (boolean)true);
        grid.add((Component)this.periodFromLabel);
        grid.add((Component)this.periodFrom);
        grid.add((Component)this.periodToLabel);
        grid.add((Component)this.periodTo);
        grid.add((Component)this.excludeCredit);
        grid.add((Component)LabelFactory.create());
        Label customerFromLabel = LabelFactory.create((String)"reporting.statements.customerFrom");
        this.customerFrom = TextComponentFactory.create();
        this.customerFrom.addPropertyChangeListener(event -> {});
        Label customerToLabel = LabelFactory.create((String)"reporting.statements.customerTo");
        this.customerTo = TextComponentFactory.create();
        this.customerTo.addPropertyChangeListener(event -> {});
        grid.add((Component)customerFromLabel);
        grid.add((Component)this.customerFrom);
        grid.add((Component)customerToLabel);
        grid.add((Component)this.customerTo);
        grid.add((Component)LabelFactory.create((String)"reporting.customer.location"));
        this.locationSelector = new LocationSelectField(this.practice);
        grid.add((Component)this.locationSelector);
        container.add((Component)grid);
        FocusGroup group = this.getFocusGroup();
        group.add((Component)this.accountType);
        group.add((Component)this.date);
        group.add((Component)this.balanceType);
        group.add((Component)this.periodFrom);
        group.add((Component)this.periodTo);
        group.add((Component)this.excludeCredit);
        group.add((Component)this.customerFrom);
        group.add((Component)this.customerTo);
        group.add((Component)this.locationSelector);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        return new ListResultSet(this.getObjects(), this.getMaxResults());
    }

    private Lookup getAccountType() {
        return this.accountType.getSelected();
    }

    private int getNumber(TextField field) {
        int from = 0;
        String fromStr = field.getText();
        if (!StringUtils.isEmpty((CharSequence)fromStr)) {
            try {
                from = Integer.valueOf(fromStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return from;
    }

    private void onBalanceTypeChanged() {
        boolean enabled = this.balanceType.getSelectedIndex() != 2;
        ComponentHelper.enable((Component)this.periodFromLabel, (boolean)enabled);
        ComponentHelper.enable((Component)this.periodFrom, (boolean)enabled);
        ComponentHelper.enable((Component)this.periodToLabel, (boolean)enabled);
        ComponentHelper.enable((Component)this.periodTo, (boolean)enabled);
    }

    class BalanceTypeListCellRenderer
    extends AbstractListCellRenderer<String> {
        BalanceTypeListCellRenderer() {
            super(String.class);
        }

        protected String toString(Component list, String object, int index) {
            return CustomerBalanceQuery.this.balanceTypeItems[index];
        }

        protected boolean isAll(Component list, String object, int index) {
            return index == 0;
        }

        protected boolean isNone(Component list, String object, int index) {
            return false;
        }
    }
}

