/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.component.processor.ProcessorListener;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;

public abstract class AbstractStatementProcessorListener
implements ProcessorListener<Statement> {
    protected static final String COMMUNICATION_REASON = "STATEMENT";
    private final StatementRules rules;
    private final CustomerAccountRules account = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
    private final CommunicationLogger logger;

    public AbstractStatementProcessorListener(Party practice, CommunicationLogger logger) {
        this.logger = logger;
        this.rules = new StatementRules(practice, (IArchetypeService)ServiceHelper.getArchetypeService(), this.account);
    }

    protected Map<String, Object> getParameters(Statement statement) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date date = statement.getStatementDate();
        BigDecimal overdueBalance = this.account.getOverdueBalance(statement.getCustomer(), date);
        result.put("statementDate", date);
        result.put("overdueBalance", overdueBalance);
        result.put("preview", statement.isPreview());
        return result;
    }

    protected void setPrinted(Statement statement) {
        this.rules.setPrinted(statement.getCustomer(), statement.getStatementDate());
    }

    protected CommunicationLogger getLogger() {
        return this.logger;
    }
}

