/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.component.processor.AbstractBatchProcessor;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.processor.BatchProcessorDialog;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.component.processor.RetryListener;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.event.VetoListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.reporting.statement.StatementProgressBarProcessor;

public abstract class AbstractStatementGenerator
extends AbstractBatchProcessor {
    private final String title;
    private final String cancelTitle;
    private final String cancelMessage;
    private final VetoListener<Vetoable> cancelListener;
    private final String retryTitle;
    private final RetryListener<Party> retryListener;
    private final HelpContext help;
    private BatchProcessorDialog dialog;

    public AbstractStatementGenerator(String title, String cancelTitle, String cancelMessage, String retryTitle, HelpContext help) {
        this.title = title;
        this.cancelTitle = cancelTitle;
        this.cancelMessage = cancelMessage;
        this.cancelListener = this::onCancel;
        this.retryTitle = retryTitle;
        this.help = help;
        this.retryListener = (customer, action, reason) -> this.onRetry(action, reason);
    }

    public void process() {
        StatementProgressBarProcessor processor = this.getProcessor();
        processor.setListener(new BatchProcessorListener(){

            public void completed() {
                AbstractStatementGenerator.this.onCompletion();
            }

            public void error(Throwable exception) {
                AbstractStatementGenerator.this.onError(exception);
            }
        });
        processor.setRetryListener(this.retryListener);
        if (processor.getCount() > 1) {
            this.dialog = new BatchProcessorDialog(this.title, (ProgressBarProcessor)processor, this.help);
            this.dialog.setCancelListener(this.cancelListener);
            this.dialog.show();
        } else {
            processor.process();
        }
    }

    protected abstract StatementProgressBarProcessor getProcessor();

    protected VetoListener<Vetoable> getCancelListener() {
        return this.cancelListener;
    }

    private void onCompletion() {
        if (this.dialog != null) {
            this.dialog.setDefaultCloseAction(null);
            this.dialog.close();
            this.dialog = null;
        }
        this.setProcessed(this.getProcessor().getProcessed());
        this.notifyCompleted();
    }

    private void onError(Throwable exception) {
        this.setProcessed(this.getProcessor().getProcessed());
        this.notifyError(exception);
    }

    private void onCancel(final Vetoable action) {
        final StatementProgressBarProcessor processor = this.getProcessor();
        processor.setCancel(true);
        final ConfirmationDialog dialog = new ConfirmationDialog(this.cancelTitle, this.cancelMessage);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent e) {
                if ("ok".equals(dialog.getAction())) {
                    action.veto(false);
                    AbstractStatementGenerator.this.onCompletion();
                } else {
                    action.veto(true);
                    processor.setCancel(false);
                    processor.process();
                }
            }
        });
        dialog.show();
    }

    private void onRetry(final Vetoable action, String reason) {
        final ConfirmationDialog dialog = new ConfirmationDialog(this.retryTitle, reason, ConfirmationDialog.RETRY_CANCEL);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent e) {
                if ("retry".equals(dialog.getAction())) {
                    action.veto(false);
                } else {
                    action.veto(true);
                    AbstractStatementGenerator.this.onCompletion();
                }
            }
        });
        dialog.show();
    }
}

