/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;

public class Statistics {
    private final Map<Entity, Map<String, Integer>> statistics = new HashMap<Entity, Map<String, Integer>>();
    private int errors;
    private int cancelled;

    public void increment(ReminderEvent reminder, ReminderType reminderType) {
        Act item = reminder.getItem();
        Entity entity = reminderType.getEntity();
        Map stats = this.statistics.computeIfAbsent(entity, k -> new HashMap());
        String archetype = item.getArchetype();
        stats.merge(archetype, 1, Integer::sum);
    }

    public int getCount() {
        int result = 0;
        for (Map<String, Integer> stats : this.statistics.values()) {
            for (Integer count : stats.values()) {
                if (count == null) continue;
                result += count.intValue();
            }
        }
        return result;
    }

    public int getCount(String shortName) {
        int result = 0;
        for (Map<String, Integer> stats : this.statistics.values()) {
            Integer count = stats.get(shortName);
            if (count == null) continue;
            result += count.intValue();
        }
        return result;
    }

    public Collection<Entity> getReminderTypes() {
        return this.statistics.keySet();
    }

    public int getCount(Entity reminderType, String ... shortNames) {
        int result = 0;
        Map<String, Integer> stats = this.statistics.get(reminderType);
        if (stats != null) {
            for (String shortName : shortNames) {
                Integer value = stats.get(shortName);
                if (value == null) continue;
                result += value.intValue();
            }
        }
        return result;
    }

    public int getErrors() {
        return this.errors;
    }

    public void addErrors(int errors) {
        this.errors += errors;
    }

    public int getCancelled() {
        return this.cancelled;
    }

    public void addCancelled(int cancelled) {
        this.cancelled += cancelled;
    }

    public void clear() {
        this.statistics.clear();
        this.errors = 0;
    }
}

