/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;

public class SingleReminderItemSource
implements ReminderItemSource {
    private final ReminderEvent event;
    private final String[] shortNames;

    public SingleReminderItemSource(Act item, Act reminder, Contact contact) {
        Party customer;
        this.shortNames = new String[]{item.getArchetype()};
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)reminder);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        ReminderEvent event = null;
        if (patient != null && (customer = ((PatientRules)ServiceHelper.getBean(PatientRules.class)).getOwner(patient)) != null) {
            event = new ReminderEvent(reminder, item, patient, customer, contact);
        }
        this.event = event;
    }

    @Override
    public String[] getArchetypes() {
        return this.shortNames;
    }

    @Override
    public Iterator<ReminderEvent> all() {
        return this.event == null ? Collections.emptyIterator() : Collections.singletonList(this.event).iterator();
    }

    @Override
    public Iterable<Reminders> query() {
        ArrayList<ReminderEvent> reminders = new ArrayList<ReminderEvent>();
        if (this.event != null) {
            reminders.add(this.event);
        }
        return Collections.singletonList(new Reminders(reminders, ReminderType.GroupBy.NONE));
    }

    @Override
    public int count() {
        return this.event == null ? 0 : 1;
    }
}

