/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.print.ObjectSetReportPrinter;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.StaticDocumentTemplateLocator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminders;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public class ReminderPrintProcessor
extends GroupedReminderProcessor<GroupedReminders> {
    private final Party location;
    private final IMPrinterFactory factory;
    private final HelpContext help;
    private boolean alwaysInteractive;
    private DocumentPrinter fallbackPrinter;
    private PrinterListener listener;

    public ReminderPrintProcessor(HelpContext help, ReminderTypes reminderTypes, ReminderRules reminderRules, PatientRules patientRules, Party location, Party practice, IArchetypeService service, ReminderConfiguration config, IMPrinterFactory factory, CommunicationLogger logger, ActionFactory actionFactory) {
        super(reminderTypes, reminderRules, patientRules, practice, (ArchetypeService)service, config, logger, actionFactory);
        this.location = location;
        this.factory = factory;
        this.help = help;
    }

    @Override
    public String getArchetype() {
        return "act.patientReminderItemPrint";
    }

    public void setListener(PrinterListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    public void setInteractiveAlways(boolean interactive) {
        this.alwaysInteractive = interactive;
    }

    @Override
    public void process(GroupedReminders reminders) {
        StaticDocumentTemplateLocator locator = new StaticDocumentTemplateLocator(reminders.getTemplate());
        List<ReminderEvent> events = reminders.getReminders();
        Context customerContext = reminders.createContext(this.getPractice());
        LocalContext printContext = new LocalContext(customerContext);
        printContext.setLocation(this.location);
        if (events.size() > 1) {
            List<ObjectSet> sets = reminders.getObjectSets(events);
            ObjectSetReportPrinter printer = this.factory.createObjectSetReportPrinter(sets, (DocumentTemplateLocator)locator, (Context)printContext);
            this.print((IMPrinter)printer, (Context)printContext, customerContext);
        } else {
            Act reminder = events.get(0).getReminder();
            IMObjectReportPrinter printer = this.factory.createIMObjectReportPrinter((IMObject)reminder, (DocumentTemplateLocator)locator, (Context)printContext);
            this.print((IMPrinter)printer, (Context)printContext, customerContext);
        }
    }

    @Override
    protected String getContactArchetype() {
        return "contact.location";
    }

    @Override
    protected GroupedReminders createPatientReminders(ReminderType.GroupBy groupBy, boolean resend) {
        return new GroupedReminders(groupBy, resend);
    }

    @Override
    protected void log(PatientReminders state, CommunicationLogger logger) {
        GroupedReminders reminders = (GroupedReminders)state;
        Party customer = reminders.getCustomer();
        Contact contact = reminders.getContact();
        Party location = reminders.getLocation();
        String subject = Messages.get((String)"reminder.log.mail.subject");
        for (ReminderEvent reminder : state.getReminders()) {
            String notes = this.getNote(reminder);
            Party patient = reminder.getPatient();
            logger.logMail(customer, patient, contact.getDescription(), subject, "PATIENT_REMINDER", null, notes, location);
        }
    }

    protected void onPrinted(DocumentPrinter printer) {
        if (this.fallbackPrinter == null) {
            this.fallbackPrinter = printer;
        }
        if (this.listener != null) {
            this.listener.printed(printer);
        }
    }

    protected void onPrintCancelled() {
        if (this.listener != null) {
            this.listener.cancelled();
        }
    }

    protected void onPrintSkipped() {
        if (this.listener != null) {
            this.listener.skipped();
        }
    }

    protected void onPrintFailed(Throwable cause) {
        if (this.listener != null) {
            this.listener.failed(cause);
        }
    }

    protected <T> void print(IMPrinter<T> printer, Context printContext, Context mailContext) {
        InteractiveIMPrinter<T> iPrinter = this.createPrinter(printer, printContext);
        DocumentPrinter defaultPrinter = printer.getDefaultPrinter();
        if (defaultPrinter == null) {
            defaultPrinter = this.fallbackPrinter;
        }
        boolean interactive = this.alwaysInteractive || defaultPrinter == null;
        iPrinter.setInteractive(interactive);
        iPrinter.setMailContext((MailContext)new CustomerMailContext(mailContext, this.help));
        iPrinter.setListener(new PrinterListener(){

            public void printed(DocumentPrinter printer) {
                ReminderPrintProcessor.this.onPrinted(printer);
            }

            public void cancelled() {
                ReminderPrintProcessor.this.onPrintCancelled();
            }

            public void skipped() {
                ReminderPrintProcessor.this.onPrintSkipped();
            }

            public void failed(Throwable cause) {
                ReminderPrintProcessor.this.onPrintFailed(cause);
            }
        });
        this.print(iPrinter, defaultPrinter);
    }

    protected <T> InteractiveIMPrinter<T> createPrinter(IMPrinter<T> printer, Context context) {
        return new InteractiveIMPrinter(printer, context, this.help);
    }

    protected void print(InteractiveIMPrinter<?> iPrinter, DocumentPrinter printer) {
        iPrinter.print(printer);
    }
}

