/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.system.ServiceHelper;

public class ReminderItemTableModel
extends AbstractIMTableModel<ObjectSet> {
    private final LayoutContext context;
    private static final int ARCHETYPE_INDEX = 0;
    private static final int STATUS_INDEX = 1;
    private static final int SEND_DATE_INDEX = 2;
    private static final int DUE_DATE_INDEX = 3;
    private static final int CUSTOMER_INDEX = 4;
    private static final int PATIENT_INDEX = 5;
    private static final int REMINDER_TYPE_INDEX = 6;
    private static final int REMINDER_COUNT_INDEX = 7;
    private static final int ERROR_INDEX = 8;

    public ReminderItemTableModel(LayoutContext context) {
        this.context = context;
        this.setTableColumnModel((TableColumnModel)this.createTableColumnModel());
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    protected Object getValue(ObjectSet object, TableColumn column, int row) {
        switch (column.getModelIndex()) {
            case 0: {
                return this.getDisplayName((IMObject)this.getReminderItem(object));
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return ((DescriptorTableColumn)column).getComponent((IMObject)this.getReminderItem(object), this.context);
            }
            case 4: {
                Party customer = (Party)object.get("customer");
                LocalContext customerContext = new LocalContext();
                customerContext.addObject((IMObject)customer);
                return new IMObjectReferenceViewer(customer.getObjectReference(), customer.getName(), true, (Context)customerContext).getComponent();
            }
            case 5: {
                Party patient = (Party)object.get("patient");
                LocalContext patientContext = new LocalContext();
                patientContext.addObject((IMObject)patient);
                return new IMObjectReferenceViewer(patient.getObjectReference(), patient.getName(), true, (Context)patientContext).getComponent();
            }
            case 6: {
                return ((DescriptorTableColumn)column).getComponent((IMObject)this.getReminder(object), this.context);
            }
        }
        return null;
    }

    private Act getReminder(ObjectSet object) {
        return (Act)object.get("reminder");
    }

    private Act getReminderItem(ObjectSet object) {
        return (Act)object.get("item");
    }

    protected DefaultTableColumnModel createTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        List itemArchetypes = DescriptorHelper.getArchetypeDescriptors((String)"act.patientReminderItem*", (ArchetypeService)service);
        List reminderArchetype = DescriptorHelper.getArchetypeDescriptors((String)"act.patientReminder", (ArchetypeService)service);
        model.addColumn(ReminderItemTableModel.createTableColumn((int)0, (String)"table.imobject.archetype"));
        model.addColumn((TableColumn)new DescriptorTableColumn(1, "status", itemArchetypes));
        model.addColumn((TableColumn)new DescriptorTableColumn(2, "startTime", itemArchetypes));
        model.addColumn((TableColumn)new DescriptorTableColumn(3, "endTime", itemArchetypes));
        model.addColumn(ReminderItemTableModel.createTableColumn((int)4, (String)"patientremindertablemodel.customer"));
        model.addColumn(this.createColumn(5, this.getDisplayName("act.patientReminder", "patient")));
        model.addColumn((TableColumn)new DescriptorTableColumn(6, "reminderType", reminderArchetype));
        model.addColumn((TableColumn)new DescriptorTableColumn(7, "count", itemArchetypes));
        model.addColumn((TableColumn)new DescriptorTableColumn(8, "error", itemArchetypes));
        return model;
    }

    private TableColumn createColumn(int index, String displayName) {
        TableColumn column = new TableColumn(index);
        column.setHeaderValue((Object)displayName);
        return column;
    }
}

