/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.query.AbstractArchetypeServiceResultSet;
import org.openvpms.web.component.im.query.AbstractQueryState;
import org.openvpms.web.component.im.query.ActQuery;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.ObjectSetQueryExecutor;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryExecutor;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;

public abstract class ReminderItemObjectSetQuery
extends ActQuery<ObjectSet> {
    private final Context context;
    private final ReminderItemQueryFactory factory;
    private LocationSelectField location;

    public ReminderItemObjectSetQuery(String status, Context context) {
        this((ActStatuses)null, context);
        this.setStatus(status);
    }

    public ReminderItemObjectSetQuery(ActStatuses statuses, Context context) {
        super(null, null, null, new String[]{"act.patientReminderItem*"}, statuses, ObjectSet.class);
        this.context = context;
        this.factory = new ReminderItemQueryFactory();
    }

    public Location getLocation() {
        return this.location != null ? this.location.getSelected() : Location.ALL;
    }

    public void setLocation(Location location) {
        if (this.location != null) {
            this.location.setSelected(location);
        }
    }

    public ReminderItemQueryFactory getFactory() {
        this.populate(this.factory);
        return this.factory;
    }

    public void setQueryState(QueryState state) {
        if (state instanceof AbstractMemento) {
            AbstractMemento memento = (AbstractMemento)state;
            this.setShortName(memento.getArchetype());
            this.setLocation(memento.getLocation());
            this.setStatuses(memento.getStatuses());
        }
    }

    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
    }

    protected void addLocationSelector(Component container) {
        if (this.location == null) {
            this.location = new LocationSelectField(this.context.getUser(), this.context.getPractice(), true);
            this.location.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    ReminderItemObjectSetQuery.this.onQuery();
                }
            });
        }
        Label label = LabelFactory.create((String)"reporting.reminder.location");
        container.add((Component)label);
        container.add((Component)this.location);
        this.getFocusGroup().add((Component)this.location);
    }

    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        this.populate(this.factory);
        final ArchetypeQuery query = this.factory.createQuery();
        return new AbstractArchetypeServiceResultSet<ObjectSet>(this.getMaxResults(), null, (QueryExecutor)new ObjectSetQueryExecutor()){

            protected ArchetypeQuery createQuery() {
                return query;
            }
        };
    }

    protected void populate(ReminderItemQueryFactory factory) {
        String shortName = this.getShortName();
        if (shortName != null) {
            factory.setArchetype(shortName);
        } else {
            factory.setArchetypes(this.getShortNames());
        }
        String[] statuses = this.getStatuses();
        if (statuses.length == 0) {
            List codes = this.getStatusLookups().getCodes();
            statuses = codes.toArray(new String[0]);
        }
        factory.setStatuses(statuses);
        factory.setLocation(this.getLocation());
    }

    protected static class AbstractMemento
    extends AbstractQueryState {
        private final String archetype;
        private final String[] statuses;
        private final Location location;

        public AbstractMemento(ReminderItemObjectSetQuery query) {
            super((Query)query);
            this.archetype = query.getShortName();
            this.statuses = query.getStatuses();
            this.location = query.getLocation();
        }

        public String getArchetype() {
            return this.archetype;
        }

        public String[] getStatuses() {
            return this.statuses;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

