/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemObjectSetQuery;

public class ReminderItemDateRangeObjectSetQuery
extends ReminderItemObjectSetQuery {
    private final DateRange dateRange = new DateRange(false);

    public ReminderItemDateRangeObjectSetQuery(String defaultStatus, Context context, String ... statuses) {
        super(new ActStatuses((LookupQuery)new StatusLookupQuery(defaultStatus, statuses)), context);
        this.dateRange.getComponent();
        this.dateRange.setAllDates(false);
        this.dateRange.setFrom(DateRules.getToday());
        this.dateRange.setTo(DateRules.getTomorrow());
    }

    protected Date getFrom() {
        return this.dateRange.getFrom();
    }

    protected Date getTo() {
        return this.dateRange.getTo();
    }

    public QueryState getQueryState() {
        return new Memento(this);
    }

    @Override
    public void setQueryState(QueryState state) {
        super.setQueryState(state);
        if (state instanceof Memento) {
            Memento memento = (Memento)state;
            this.dateRange.setFrom(memento.from);
            this.dateRange.setTo(memento.to);
        }
    }

    @Override
    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addStatusSelector(container);
        container.add(this.dateRange.getComponent());
        this.addLocationSelector(container);
    }

    @Override
    protected void populate(ReminderItemQueryFactory factory) {
        super.populate(factory);
        factory.setFrom(this.dateRange.getFrom());
        factory.setTo(this.dateRange.getTo());
    }

    private static class Memento
    extends ReminderItemObjectSetQuery.AbstractMemento {
        private final Date from;
        private final Date to;

        public Memento(ReminderItemDateRangeObjectSetQuery query) {
            super(query);
            this.from = query.getFrom();
            this.to = query.getTo();
        }
    }

    private static class StatusLookupQuery
    extends NodeLookupQuery {
        private final Lookup defaultLookup;

        StatusLookupQuery(String defaultCode, String ... codes) {
            super("act.patientReminderItemEmail", "status", codes);
            this.defaultLookup = defaultCode != null ? this.getLookup(defaultCode, this.getLookups()) : null;
        }

        public Lookup getDefault() {
            return this.defaultLookup;
        }
    }
}

