/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.archetype.rules.patient.reminder.GroupingReminderIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.processor.BatchProcessorDialog;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderPreviewer;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessorFactory;
import org.openvpms.web.workspace.reporting.reminder.ReminderGenerator;
import org.openvpms.web.workspace.reporting.reminder.ReminderGeneratorFactory;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemBrowser;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemProgressBarProcessor;

class ReminderItemCRUDWindow
extends AbstractViewCRUDWindow<Act> {
    private final ReminderItemBrowser browser;
    private final boolean resend;
    private final ReminderRules rules;
    private static final String SEND_ID = "button.send";
    private static final String SEND_ALL_ID = "button.sendAll";
    private static final String COMPLETE_ID = "button.complete";
    private static final String COMPLETE_ALL_ID = "button.completeAll";
    private static final String PREVIEW_ID = "button.preview";

    public ReminderItemCRUDWindow(ReminderItemBrowser browser, boolean resend, Context context, HelpContext help) {
        super(Archetypes.create((String)"act.patientReminderItem*", Act.class), (IMObjectActions)Actions.INSTANCE, context, help);
        this.browser = browser;
        this.resend = resend;
        this.rules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
    }

    public Act getReminder() {
        Act item = (Act)this.getObject();
        return item != null ? this.getReminder(item) : null;
    }

    public void edit() {
        Act item = (Act)this.getObject();
        if (item != null) {
            Act reminder = this.getReminder(item);
            if (reminder == null) {
                ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getDisplayName("act.patientReminder")}));
            } else {
                IMObjectBean bean = this.getBean((IMObject)reminder);
                ActRelationship relationship = (ActRelationship)bean.getValue("items", ActRelationship.class, Predicates.targetEquals((IMObject)item));
                this.edit((IMObject)reminder, Arrays.asList(new Selection("items", null), new Selection(null, (IMObject)relationship)));
            }
        }
    }

    protected void view(Act object) {
        Act reminder = object != null ? this.getReminder(object) : null;
        super.view((IMObject)reminder);
    }

    protected void onSaved(Act object, boolean isNew) {
        Act item = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (item != null) {
            BrowserState state = this.browser.getBrowserState();
            super.onSaved((IMObject)item, false);
            if (state != null) {
                this.browser.setBrowserState(state);
            }
        } else {
            this.onDeleted((Act)this.getObject());
        }
    }

    protected void onDeleted(Act object) {
        BrowserState state = this.browser.getBrowserState();
        super.onDeleted((IMObject)object);
        if (state != null) {
            this.browser.setBrowserState(state);
        }
    }

    protected void onRefresh(Act object) {
        Act item = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (item != null) {
            BrowserState state = this.browser.getBrowserState();
            super.onRefresh((IMObject)item);
            if (state != null) {
                this.browser.setBrowserState(state);
            }
        }
    }

    protected Act getReminder(Act item) {
        return (Act)this.getBean((IMObject)item).getSource("reminder", Act.class);
    }

    protected IMObjectViewer createViewer(IMObject object) {
        return super.createViewer(object);
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createEditButton());
    }

    protected Button createSendButton() {
        return ButtonFactory.create((String)SEND_ID, this::onSend);
    }

    protected Button createSendAllButton() {
        return ButtonFactory.create((String)SEND_ALL_ID, this::onSendAll);
    }

    protected Button createCompleteButton() {
        return ButtonFactory.create((String)COMPLETE_ID, this::onComplete);
    }

    protected Button createCompleteAllButton() {
        return ButtonFactory.create((String)COMPLETE_ALL_ID, this::onCompleteAll);
    }

    protected Button createPreviewButton() {
        return ButtonFactory.create((String)PREVIEW_ID, this::onPreview);
    }

    protected void onPreview() {
        ObjectSet selected = (ObjectSet)this.browser.getBrowser().getSelected();
        if (selected != null) {
            Act item = (Act)selected.get("item");
            Party customer = (Party)selected.get("customer");
            ReminderItemQueryFactory factory = this.browser.getFactory();
            String archetype = item.getArchetype();
            ReminderItemQueryFactory copy = factory.copy(archetype);
            copy.setCustomer(customer);
            ReminderGeneratorFactory generators = (ReminderGeneratorFactory)ServiceHelper.getBean(ReminderGeneratorFactory.class);
            Context context = this.getContext();
            PatientReminderProcessorFactory processorFactory = generators.createFactory(context.getLocation(), context.getPractice(), this.getHelpContext());
            ReminderConfiguration config = processorFactory.getConfiguration();
            GroupingReminderIterator iterator = new GroupingReminderIterator(copy, processorFactory.getReminderTypes(), 100, config.getGroupByCustomerPolicy(), config.getGroupByPatientPolicy(), (IArchetypeService)ServiceHelper.getArchetypeService());
            Reminders found = null;
            while (iterator.hasNext()) {
                Reminders reminders = iterator.next();
                if (!reminders.contains(item)) continue;
                found = reminders;
                break;
            }
            if (found != null) {
                PatientReminderProcessor<?> processor = processorFactory.create(archetype);
                PatientReminderPreviewer previewer = generators.createPreviewer(processor, this.getHelpContext());
                this.preview(item, found, previewer);
            }
        }
    }

    protected void preview(Act item, Reminders reminders, PatientReminderPreviewer previewer) {
        previewer.preview(item, reminders.getReminders(), reminders.getGroupBy(), new Date(), true);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled("button.edit", enable);
        buttons.setEnabled(SEND_ID, enable);
        buttons.setEnabled(COMPLETE_ID, enable);
    }

    protected ReminderItemQueryFactory getQueryFactory() {
        return this.browser.getFactory();
    }

    private void onSend() {
        final Act item = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (item != null) {
            if ("CANCELLED".equals(item.getStatus())) {
                ConfirmationDialog.show((String)Messages.get((String)"reporting.reminder.send.title"), (String)Messages.format((String)"reporting.reminder.send.sendcancelled", (Object[])new Object[0]), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        ReminderItemCRUDWindow.this.send(item);
                    }
                });
            } else {
                this.send(item);
            }
        }
    }

    private void send(final Act item) {
        try {
            HelpContext help = this.getHelpContext().subtopic("send");
            ReminderGeneratorFactory factory = (ReminderGeneratorFactory)ServiceHelper.getBean(ReminderGeneratorFactory.class);
            Context context = this.getContext();
            Party location = context.getLocation();
            Party practice = context.getPractice();
            ReminderGenerator generator = factory.create(item, null, location, practice, help);
            generator.setResend(this.resend);
            generator.setListener(new BatchProcessorListener(){

                public void completed() {
                    ReminderItemCRUDWindow.this.onRefresh(item);
                    if ("CANCELLED".equals(item.getStatus())) {
                        String error = ReminderItemCRUDWindow.this.getBean((IMObject)item).getString("error");
                        String message = !StringUtils.isEmpty((CharSequence)error) ? error : Messages.get((String)"reporting.reminder.send.cancelled");
                        ErrorDialog.show((String)Messages.get((String)"reporting.reminder.send.title"), (String)message);
                    } else if ("ERROR".equals(item.getStatus())) {
                        String error = ReminderItemCRUDWindow.this.getBean((IMObject)item).getString("error");
                        ErrorDialog.show((String)Messages.get((String)"reporting.reminder.send.title"), (String)error);
                    }
                }

                public void error(Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            });
            generator.process();
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private void onSendAll() {
        String title = Messages.get((String)"reporting.reminder.run.title");
        ReminderItemQueryFactory queryFactory = this.getQueryFactory();
        Object[] statuses = queryFactory.getStatuses();
        if (statuses == null || statuses.length == 0 || ArrayUtils.contains((Object[])statuses, (Object)"CANCELLED")) {
            InformationDialog.show((String)title, (String)Messages.get((String)"reporting.reminder.run.nocancelled"));
        } else {
            String message = Messages.get((String)"reporting.reminder.run.message");
            HelpContext help = this.getHelpContext().subtopic("confirmsend");
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO, help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    ReminderItemCRUDWindow.this.generateReminders();
                }
            });
            dialog.show();
        }
    }

    private void onComplete() {
        ConfirmationDialog.show((String)Messages.get((String)"reporting.reminder.complete.title"), (String)Messages.get((String)"reporting.reminder.complete.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                ReminderItemCRUDWindow.this.onCompleteConfirmed();
            }
        });
    }

    private void onCompleteConfirmed() {
        IMObjectBean bean;
        Act reminder;
        String status;
        Act object = (Act)this.getObject();
        Act item = (Act)IMObjectHelper.reload((IMObject)object);
        if (item != null && ("PENDING".equals(status = item.getStatus()) || "ERROR".equals(status)) && (reminder = (Act)(bean = this.getBean((IMObject)item)).getSource("reminder", Act.class)) != null) {
            this.complete(item, reminder);
        }
        this.onRefresh(object);
    }

    private void onCompleteAll() {
        ConfirmationDialog.show((String)Messages.get((String)"reporting.reminder.completeall.prompt.title"), (String)Messages.get((String)"reporting.reminder.completeall.prompt.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                ReminderItemCRUDWindow.this.onCompleteAllConfirmed();
            }
        });
    }

    private void onCompleteAllConfirmed() {
        ReminderItemQueryFactory factory = this.getQueryFactory();
        if (factory != null) {
            CompleteAllProgressBarProcessor processor = new CompleteAllProgressBarProcessor(factory);
            BatchProcessorDialog dialog = new BatchProcessorDialog(Messages.get((String)"reporting.reminder.completeall.run.title"), Messages.get((String)"reporting.reminder.completeall.run.message"), (ProgressBarProcessor)processor, true, this.getHelpContext());
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    ReminderItemCRUDWindow.this.onRefresh((Act)ReminderItemCRUDWindow.this.getObject());
                }
            });
            dialog.show();
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void complete(Act item, Act reminder) {
        item.setStatus("COMPLETED");
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.setValue("error", null);
        ArrayList<Act> toSave = new ArrayList<Act>();
        toSave.add(item);
        if (this.rules.updateReminder(reminder, item)) {
            toSave.add(reminder);
        }
        SaveHelper.save(toSave);
    }

    private void generateReminders() {
        try {
            HelpContext help = this.getHelpContext().subtopic("send");
            ReminderGeneratorFactory factory = (ReminderGeneratorFactory)ServiceHelper.getBean(ReminderGeneratorFactory.class);
            ReminderItemQueryFactory queryFactory = this.getQueryFactory();
            Context context = this.getContext();
            Party location = context.getLocation();
            Party practice = context.getPractice();
            ReminderGenerator generator = factory.create(queryFactory, location, practice, help);
            generator.setResend(this.resend);
            generator.setListener(new BatchProcessorListener(){

                public void completed() {
                    ReminderItemCRUDWindow.this.onRefresh((Act)ReminderItemCRUDWindow.this.getObject());
                }

                public void error(Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            });
            generator.process();
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private static final class Actions
    extends ActActions<Act> {
        public static final Actions INSTANCE = new Actions();

        private Actions() {
        }

        public boolean canCreate() {
            return false;
        }

        public boolean canDelete(Act act) {
            return true;
        }

        public boolean canEdit(Act act) {
            return true;
        }
    }

    private class CompleteAllProgressBarProcessor
    extends ReminderItemProgressBarProcessor {
        public CompleteAllProgressBarProcessor(ReminderItemQueryFactory factory) {
            super(factory);
        }

        @Override
        protected void process(Act item, Act reminder) {
            String status = item.getStatus();
            if ("PENDING".equals(status) || "ERROR".equals(status)) {
                ReminderItemCRUDWindow.this.complete(item, reminder);
                this.updated();
            }
        }
    }
}

