/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.component.processor.AbstractBatchProcessor;
import org.openvpms.archetype.component.processor.AsynchronousBatchProcessor;
import org.openvpms.archetype.component.processor.BatchProcessor;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessorFactory;
import org.openvpms.web.workspace.reporting.reminder.ReminderBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderGenerationDialog;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemQuerySource;
import org.openvpms.web.workspace.reporting.reminder.SingleReminderItemSource;

public class ReminderGenerator
extends AbstractBatchProcessor {
    private final HelpContext help;
    private final List<ReminderBatchProcessor> processors = new ArrayList<ReminderBatchProcessor>();
    private boolean multipleReminders = true;

    public ReminderGenerator(Act item, Act reminder, Contact contact, HelpContext help, PatientReminderProcessorFactory processorFactory) {
        this.help = help;
        SingleReminderItemSource query = new SingleReminderItemSource(item, reminder, contact);
        ReminderBatchProcessor processor = processorFactory.createBatchProcessor(query);
        this.processors.add(processor);
        this.multipleReminders = false;
    }

    public ReminderGenerator(ReminderItemQueryFactory factory, HelpContext help, PatientReminderProcessorFactory processorFactory) {
        this.help = help;
        ReminderTypes reminderTypes = processorFactory.getReminderTypes();
        ReminderConfiguration config = processorFactory.getConfiguration();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (String archetype : DescriptorHelper.getShortNames((String[])factory.getArchetypes(), (ArchetypeService)service)) {
            ReminderItemQueryFactory clone = factory.copy(archetype);
            ReminderBatchProcessor processor = processorFactory.createBatchProcessor(new ReminderItemQuerySource(clone, reminderTypes, config));
            this.processors.add(processor);
        }
    }

    public void process() {
        if (!this.processors.isEmpty()) {
            if (this.multipleReminders) {
                ReminderBatchProcessor processor;
                boolean popup = true;
                if (this.processors.size() == 1 && !((processor = this.processors.get(0)) instanceof AsynchronousBatchProcessor)) {
                    popup = false;
                }
                if (popup) {
                    ReminderGenerationDialog dialog = new ReminderGenerationDialog(this.processors, this.help);
                    dialog.show();
                    dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                        public void onClose(WindowPaneEvent event) {
                            ReminderGenerator.this.onCompletion();
                        }
                    });
                } else {
                    processor = this.processors.get(0);
                    this.process(processor);
                }
            } else {
                ReminderBatchProcessor processor = this.processors.get(0);
                this.process(processor);
            }
        } else {
            InformationDialog.show((String)Messages.get((String)"reporting.reminder.none.title"), (String)Messages.get((String)"reporting.reminder.none.message"));
        }
    }

    public void setResend(boolean resend) {
        for (ReminderBatchProcessor processor : this.processors) {
            processor.setResend(resend);
        }
    }

    private void process(final ReminderBatchProcessor processor) {
        processor.setListener(new BatchProcessorListener(){

            public void completed() {
                if (processor.hasMoreReminders()) {
                    InformationDialog.show((String)Messages.get((String)"reporting.reminder.run.title"), (String)Messages.format((String)"reporting.reminder.run.rerun", (Object[])new Object[]{processor.getTitle()}), (WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                        public void onClose(WindowPaneEvent event) {
                            ReminderGenerator.this.onCompletion();
                        }
                    });
                } else {
                    ReminderGenerator.this.onCompletion();
                }
            }

            public void error(Throwable exception) {
                ReminderGenerator.this.onError(exception);
            }
        });
        processor.process();
    }

    private void onCompletion() {
        this.updateProcessed();
        this.notifyCompleted();
    }

    private void onError(Throwable exception) {
        this.updateProcessed();
        this.notifyError(exception);
    }

    private void updateProcessed() {
        int processed = 0;
        for (BatchProcessor batchProcessor : this.processors) {
            processed += batchProcessor.getProcessed();
        }
        this.setProcessed(processed);
    }
}

