/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;

public class PatientReminders {
    private final List<ReminderEvent> reminders = new ArrayList<ReminderEvent>();
    private final ReminderType.GroupBy groupBy;
    private final List<ReminderEvent> cancelled = new ArrayList<ReminderEvent>();
    private final List<ReminderEvent> errors = new ArrayList<ReminderEvent>();
    private final Map<ReminderEvent, List<Act>> updated = new LinkedHashMap<ReminderEvent, List<Act>>();
    private final List<ReminderEvent> saved = new ArrayList<ReminderEvent>();
    private final boolean resend;

    public PatientReminders(ReminderType.GroupBy groupBy, boolean resend) {
        this.groupBy = groupBy;
        this.resend = resend;
    }

    public void addReminder(ReminderEvent reminder) {
        this.reminders.add(reminder);
    }

    public List<ReminderEvent> getReminders() {
        return new ArrayList<ReminderEvent>(this.reminders);
    }

    public ReminderEvent getFirst() {
        return !this.reminders.isEmpty() ? this.reminders.get(0) : null;
    }

    public boolean canSend() {
        return this.getFirst() != null;
    }

    public ReminderType.GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void addUpdated(ReminderEvent reminder, Act ... acts) {
        this.addUpdated(reminder, Arrays.asList(acts));
    }

    public void addUpdated(ReminderEvent reminder, List<Act> acts) {
        this.updated.put(reminder, acts);
    }

    public Map<ReminderEvent, List<Act>> getUpdated() {
        return this.updated;
    }

    public void addCancelled(ReminderEvent reminder) {
        this.cancelled.add(reminder);
        this.reminders.remove(reminder);
    }

    public List<ReminderEvent> getCancelled() {
        return this.cancelled;
    }

    public void addError(ReminderEvent reminder) {
        this.errors.add(reminder);
        this.reminders.remove(reminder);
        this.cancelled.remove(reminder);
    }

    public List<ReminderEvent> getErrors() {
        return this.errors;
    }

    public void addSaved(ReminderEvent reminder) {
        this.saved.add(reminder);
    }

    public List<ReminderEvent> getUnsaved() {
        LinkedHashSet<ReminderEvent> result = new LinkedHashSet<ReminderEvent>(this.reminders);
        result.addAll(this.updated.keySet());
        result.removeAll(this.saved);
        return new ArrayList<ReminderEvent>(result);
    }

    public boolean getResend() {
        return this.resend;
    }

    public Context createContext(Party practice) {
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        return context;
    }

    public int getProcessed() {
        return this.reminders.size() + this.cancelled.size() + this.errors.size();
    }

    public List<ObjectSet> getObjectSets(List<ReminderEvent> reminders) {
        return new ArrayList<ReminderEvent>(reminders);
    }
}

