/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderCount;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminders;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public abstract class GroupedReminderProcessor<T extends GroupedReminders>
extends PatientReminderProcessor<T> {
    public GroupedReminderProcessor(ReminderTypes reminderTypes, ReminderRules reminderRules, PatientRules patientRules, Party practice, ArchetypeService service, ReminderConfiguration config, CommunicationLogger logger, ActionFactory actionFactory) {
        super(reminderTypes, reminderRules, patientRules, practice, service, config, logger, actionFactory);
    }

    @Override
    protected void prepare(T reminders) {
        DocumentTemplate template = null;
        Party customer = null;
        Contact contact = null;
        Party location = null;
        ReminderEvent event = ((PatientReminders)reminders).getFirst();
        if (event != null) {
            customer = event.getCustomer();
            contact = this.getContact(customer, this.createContactMatcher(), event.getContact());
            if (contact != null) {
                location = this.getLocation(customer);
                this.populate((PatientReminders)reminders, contact, location);
                try {
                    template = this.getTemplate((PatientReminders)reminders, ((PatientReminders)reminders).getGroupBy());
                }
                catch (ReportingException exception) {
                    this.error(reminders, (Throwable)((Object)exception));
                }
            } else {
                this.noContact(reminders);
            }
        }
        ((GroupedReminders)reminders).setCustomer(customer);
        ((GroupedReminders)reminders).setContact(contact);
        ((GroupedReminders)reminders).setLocation(location);
        ((GroupedReminders)reminders).setTemplate(template);
    }

    protected void noContact(T reminders) {
        String message = Messages.format((String)"reporting.reminder.nocontact", (Object[])new Object[]{DescriptorHelper.getDisplayName((String)this.getContactArchetype(), (ArchetypeService)this.getService())});
        this.error(reminders, message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DocumentTemplate getTemplate(PatientReminders reminders, ReminderType.GroupBy groupBy) {
        DocumentTemplate template;
        if (reminders.getReminders().size() > 1) {
            if (groupBy == ReminderType.GroupBy.CUSTOMER) {
                template = this.getConfig().getCustomerGroupedReminderTemplate();
                if (template != null) return template;
                throw new ReportingException(ReportingException.ErrorCode.NoCustomerGroupedReminderTemplate, new Object[0]);
            }
            if (groupBy != ReminderType.GroupBy.PATIENT) throw new IllegalArgumentException("Multiple reminders specified for incorrect groupBy: " + groupBy);
            template = this.getConfig().getPatientGroupedReminderTemplate();
            if (template != null) return template;
            throw new ReportingException(ReportingException.ErrorCode.NoPatientGroupedReminderTemplate, new Object[0]);
        }
        ReminderEvent first = reminders.getFirst();
        ReminderType reminderType = this.getReminderType(first);
        if (reminderType == null) {
            throw new IllegalStateException("Cannot determine reminder type");
        }
        int reminderCount = first.getReminderCount();
        ReminderCount count = reminderType.getReminderCount(reminderCount);
        if (count == null) {
            throw new ReportingException(ReportingException.ErrorCode.NoReminderCount, reminderType.getName(), reminderCount);
        }
        template = count.getTemplate();
        if (template != null) return template;
        throw new ReportingException(ReportingException.ErrorCode.ReminderMissingDocTemplate, new Object[0]);
    }

    protected ContactMatcher createContactMatcher() {
        return this.createContactMatcher(this.getContactArchetype());
    }

    protected abstract String getContactArchetype();
}

