/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderPreviewer;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public abstract class AbstractPatientReminderPreviewer<T extends PatientReminders>
implements PatientReminderPreviewer {
    private final PatientReminderProcessor<T> processor;
    private final HelpContext help;

    public AbstractPatientReminderPreviewer(PatientReminderProcessor<T> processor, HelpContext help) {
        this.processor = processor;
        this.help = help;
    }

    @Override
    public void preview(Act item, List<ReminderEvent> reminders, ReminderType.GroupBy groupBy, Date cancelDate, boolean sent) {
        T state = this.processor.prepare(reminders, groupBy, cancelDate, sent);
        if (!Reminders.contains((Act)item, ((PatientReminders)state).getReminders())) {
            if (Reminders.contains((Act)item, ((PatientReminders)state).getCancelled())) {
                InformationDialog.show((String)Messages.get((String)"reporting.reminder.send.cancelled"));
            } else {
                item = Reminders.findItem((Act)item, ((PatientReminders)state).getErrors());
                String error = null;
                if (item != null) {
                    IMObjectBean bean = IMObjectHelper.getBean((IMObject)item);
                    error = bean.getString("error");
                }
                InformationDialog.show((String)Messages.format((String)"reporting.reminder.preview.error", (Object[])new Object[]{error}));
            }
        } else {
            this.preview(state, this.processor, this.help);
        }
    }

    protected abstract void preview(T var1, PatientReminderProcessor<T> var2, HelpContext var3);
}

