/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment.paymentprocessor;

import java.util.Date;
import java.util.List;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;

public class PaymentProcessorActResultSet
extends ActResultSet<FinancialAct> {
    private final Party location;
    private final List<Party> locations;

    public PaymentProcessorActResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint[] participants, Party location, List<Party> locations, Date from, Date to, String[] statuses, int pageSize, SortConstraint[] sort) {
        super(archetypes, value, participants, from, to, statuses, false, null, pageSize, sort);
        this.setDistinct(true);
        this.location = location;
        this.locations = locations;
    }

    protected ArchetypeQuery createQuery(ShortNameConstraint archetypes) {
        ArchetypeQuery query = super.createQuery(archetypes);
        query.getArchetypeConstraint().setAlias("act");
        if (this.getValue() != null) {
            query.add((IConstraint)Constraints.leftJoin((String)"transactionId", (String)"ids"));
            query.add((IConstraint)Constraints.leftJoin((String)"customer").add((IConstraint)Constraints.leftJoin((String)"entity", (String)"customere")));
        }
        if (this.location != null || !this.locations.isEmpty()) {
            query.add((IConstraint)Constraints.leftJoin((String)"location", (String)"location"));
            if (this.location != null) {
                query.add((IConstraint)Constraints.eq((String)"location.entity", (Object)this.location));
            } else {
                OrConstraint or = new OrConstraint();
                for (Party location : this.locations) {
                    or.add((IConstraint)Constraints.eq((String)"location.entity", (Object)location));
                }
                query.add((IConstraint)or);
            }
        }
        return query;
    }

    protected List<IConstraint> createValueConstraints(String value, List<String> nodes) {
        List result = super.createValueConstraints(value, nodes);
        result.add(Constraints.eq((String)"ids.identity", (Object)value));
        if (this.getId(value) == null) {
            result.add(Constraints.eq((String)"customere.name", (Object)value));
        }
        return result;
    }
}

