/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment.eftpos;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentActPrinter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.print.AbstractPrinter;
import org.openvpms.web.component.print.InteractivePrinter;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class LastReceiptPrinter
extends InteractivePrinter {
    private final String merchantReceipt;
    private final String merchantReceiptWithSig;
    private final String customerReceipt;

    public LastReceiptPrinter(String merchantReceipt, String merchantReceiptWithSig, String customerReceipt, PrinterContext printerContext, Context context, HelpContext help) {
        super((Printer)new ReceiptPrinter(printerContext, context), context, help);
        this.merchantReceipt = merchantReceipt;
        this.merchantReceiptWithSig = merchantReceiptWithSig;
        this.customerReceipt = customerReceipt;
    }

    protected PrintDialog createDialog() {
        return new LastReceiptPrintDialog(this.getHelpContext());
    }

    protected ReceiptPrinter getPrinter() {
        return (ReceiptPrinter)super.getPrinter();
    }

    private static class ReceiptPrinter
    extends AbstractPrinter {
        private final Context context;
        private final ContextDocumentTemplateLocator locator;
        private DocumentActPrinter printer;
        private DocumentPrinter defaultPrinter;

        public ReceiptPrinter(PrinterContext printerContext, Context context) {
            super(printerContext, context);
            this.context = context;
            this.locator = new ContextDocumentTemplateLocator("act.EFTPOSReceiptCustomer", context);
        }

        public void setReceipt(String receipt) {
            IArchetypeService service = this.getService();
            DocumentAct act = (DocumentAct)service.create("act.EFTPOSReceiptCustomer", DocumentAct.class);
            IMObjectBean bean = service.getBean((IMObject)act);
            bean.setValue("receipt", (Object)receipt);
            this.printer = new DocumentActPrinter(act, (DocumentTemplateLocator)this.locator, this.getPrinterContext(), this.context, (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class));
        }

        public void print(DocumentPrinter printer) {
            this.printer.print(printer);
        }

        public DocumentPrinter getDefaultPrinter() {
            if (this.defaultPrinter == null) {
                DocumentTemplate template = this.locator.getTemplate();
                this.defaultPrinter = this.getDefaultPrinter(template);
            }
            return this.defaultPrinter;
        }

        public Document getDocument() {
            return this.printer.getDocument();
        }

        public Document getDocument(String mimeType, boolean email) {
            return this.printer.getDocument(mimeType, email);
        }

        public boolean getInteractive() {
            return true;
        }

        public String getDisplayName() {
            return this.printer.getDisplayName();
        }
    }

    class LastReceiptPrintDialog
    extends PrintDialog {
        private final List<RadioButton> options;

        public LastReceiptPrintDialog(HelpContext help) {
            super(Messages.get((String)"reporting.eftpos.print.lastReceipt"), true, true, false, null, help);
            this.options = new ArrayList<RadioButton>();
            ButtonGroup group = new ButtonGroup();
            if (LastReceiptPrinter.this.merchantReceipt != null) {
                this.options.add(ButtonFactory.create((String)"reporting.eftpos.print.merchantreceipt", (ButtonGroup)group, () -> this.onSelected(LastReceiptPrinter.this.merchantReceipt)));
            }
            if (LastReceiptPrinter.this.merchantReceiptWithSig != null) {
                this.options.add(ButtonFactory.create((String)"reporting.eftpos.print.merchantreceiptwithsig", (ButtonGroup)group, () -> this.onSelected(LastReceiptPrinter.this.merchantReceiptWithSig)));
            }
            if (LastReceiptPrinter.this.customerReceipt != null) {
                this.options.add(ButtonFactory.create((String)"reporting.eftpos.print.customerreceipt", (ButtonGroup)group, () -> this.onSelected(LastReceiptPrinter.this.customerReceipt)));
            }
            if (this.options.size() == 1) {
                this.options.get(0).setSelected(true);
            }
        }

        protected void onPreview() {
            LastReceiptPrinter.this.preview();
        }

        protected void onMail() {
            LastReceiptPrinter.this.mail(this);
        }

        protected void doLayout() {
            Column column = ColumnFactory.create((String)"WideCellSpacing");
            this.doLayout((Component)column);
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        }

        protected void doLayout(Component container) {
            for (RadioButton option : this.options) {
                container.add((Component)option);
            }
            super.doLayout(container);
            this.enableButtons();
        }

        private void onSelected(String receipt) {
            LastReceiptPrinter.this.getPrinter().setReceipt(receipt);
            this.enableButtons();
        }

        private void enableButtons() {
            boolean selected = false;
            for (RadioButton button : this.options) {
                if (!button.isSelected()) continue;
                selected = true;
                break;
            }
            this.getButtons().setEnabled("ok", selected);
            this.getButtons().setEnabled("button.preview", selected);
            this.getButtons().setEnabled("button.mail", selected);
        }
    }
}

