/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.deposit;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.finance.deposit.DepositQuery;
import org.openvpms.archetype.rules.finance.deposit.DepositRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.print.ObjectSetReportPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.FinancialActCRUDWindow;

public class DepositCRUDWindow
extends FinancialActCRUDWindow {
    private static final String DEPOSIT_ID = "deposit";

    public DepositCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        Button deposit = ButtonFactory.create((String)DEPOSIT_ID, (Runnable)this.action(this::deposit, "deposit.deposit.title"));
        buttons.add(deposit);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        boolean enableDeposit = false;
        if (enable) {
            FinancialAct act = (FinancialAct)this.getObject();
            enableDeposit = "UNDEPOSITED".equals(act.getStatus());
        }
        buttons.setEnabled(DEPOSIT_ID, enableDeposit);
        this.enablePrintPreview(buttons, enable);
    }

    protected void deposit(final FinancialAct object) {
        if ("UNDEPOSITED".equals(object.getStatus())) {
            String title = Messages.get((String)"deposit.deposit.title");
            String message = Messages.get((String)"deposit.deposit.message");
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, this.getHelpContext().subtopic(DEPOSIT_ID));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    DepositCRUDWindow.this.doDeposit(object);
                }
            });
            dialog.show();
        } else {
            this.onRefresh((IMObject)object);
        }
    }

    protected void print(FinancialAct object) {
        IPage set = new DepositQuery(object, (IArchetypeService)ServiceHelper.getArchetypeService()).query();
        Context context = this.getContext();
        IMPrinterFactory printerFactory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        ObjectSetReportPrinter printer = printerFactory.createObjectSetReportPrinter((Iterable)set.getResults(), (DocumentTemplateLocator)new ContextDocumentTemplateLocator("act.bankDeposit", context), context);
        String title = Messages.format((String)"imobject.print.title", (Object[])new Object[]{this.getArchetypes().getDisplayName()});
        InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(title, (IMPrinter)printer, context, this.getHelpContext().subtopic("print"));
        iPrinter.setMailContext(this.getMailContext());
        iPrinter.print();
    }

    protected void preview(FinancialAct object) {
        IPage set = new DepositQuery(object, (IArchetypeService)ServiceHelper.getArchetypeService()).query();
        Context context = this.getContext();
        IMPrinterFactory printerFactory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        ObjectSetReportPrinter printer = printerFactory.createObjectSetReportPrinter((Iterable)set.getResults(), (DocumentTemplateLocator)new ContextDocumentTemplateLocator("act.bankDeposit", context), context);
        this.preview((Printer)printer);
    }

    private void doDeposit(FinancialAct act) {
        try {
            DepositRules.deposit((Act)act, (IArchetypeService)ServiceHelper.getArchetypeService());
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.onRefresh((IMObject)act);
    }
}

