/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.account;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.BrowserCRUDWindowTab;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.component.workspace.TabbedWorkspace;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;
import org.openvpms.web.workspace.reporting.account.AccountActCRUDWindow;
import org.openvpms.web.workspace.reporting.payment.TransactionCRUDWindow;

public abstract class AccountReportingWorkspace
extends TabbedWorkspace<FinancialAct> {
    private final Preferences preferences;

    public AccountReportingWorkspace(String id, Context context, MailContext mailContext, Preferences preferences) {
        super(id, context);
        this.setMailContext(mailContext);
        this.preferences = preferences;
    }

    public Component getSummary() {
        Party customer;
        Component result = null;
        Tab tab = (Tab)this.getSelected();
        Party party = customer = tab != null ? tab.getCustomer() : null;
        if (customer != null) {
            CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
            CustomerSummary summary = factory.createCustomerSummary(this.getContext(), this.getHelpContext(), this.preferences);
            result = summary.getSummary(customer);
        }
        return result;
    }

    protected Class<FinancialAct> getType() {
        return FinancialAct.class;
    }

    protected void addTabs(ObjectTabPaneModel<TabComponent> model) {
        this.addWorkInProgress(model);
        this.addSearch(model);
    }

    protected void addWorkInProgress(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("wip");
        Query<FinancialAct> query = this.createWorkInProgressQuery(help);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.getContext(), help);
        layoutContext.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        QueryBrowser browser = (QueryBrowser)BrowserFactory.create(query, null, this.createTableModel(query.getShortNames(), (LayoutContext)layoutContext), (LayoutContext)layoutContext);
        Archetypes archetypes = Archetypes.create((String[])query.getShortNames(), FinancialAct.class);
        AccountActCRUDWindow window = this.createWorkInProgressCRUDWindow((Archetypes<FinancialAct>)archetypes, (QueryBrowser<FinancialAct>)browser, help);
        this.addTab("reporting.account.wip", model, (TabComponent)new AccountTab((Browser<FinancialAct>)browser, window));
    }

    protected abstract Query<FinancialAct> createWorkInProgressQuery(HelpContext var1);

    protected abstract AccountActCRUDWindow createWorkInProgressCRUDWindow(Archetypes<FinancialAct> var1, QueryBrowser<FinancialAct> var2, HelpContext var3);

    protected abstract Query<FinancialAct> createSearchQuery(HelpContext var1);

    protected abstract AccountActCRUDWindow createSearchCRUDWindow(Archetypes<FinancialAct> var1, QueryBrowser<FinancialAct> var2, HelpContext var3);

    protected IMObjectTableModel<FinancialAct> createTableModel(String[] archetypes, LayoutContext context) {
        return new TableModel(archetypes, context);
    }

    protected void addSearch(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("search");
        Query<FinancialAct> query = this.createSearchQuery(help);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.getContext(), help);
        layoutContext.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        QueryBrowser browser = (QueryBrowser)BrowserFactory.create(query, null, this.createTableModel(query.getShortNames(), (LayoutContext)layoutContext), (LayoutContext)layoutContext);
        Archetypes archetypes = Archetypes.create((String[])query.getShortNames(), FinancialAct.class);
        AccountActCRUDWindow window = this.createSearchCRUDWindow((Archetypes<FinancialAct>)archetypes, (QueryBrowser<FinancialAct>)browser, help);
        this.addTab("reporting.account.search", model, (TabComponent)new AccountTab((Browser<FinancialAct>)browser, window, false));
    }

    private static class TableModel
    extends DescriptorTableModel<FinancialAct> {
        public TableModel(String[] archetypes, LayoutContext context) {
            super(archetypes, context);
        }

        protected String[] getNodeNames() {
            return new String[]{"id", "startTime", "customer", "status", "amount", "notes"};
        }
    }

    protected class TransactionTab
    extends Tab {
        public TransactionTab(Browser<FinancialAct> browser, TransactionCRUDWindow window, boolean refreshOnShow) {
            super(browser, (AbstractCRUDWindow<FinancialAct>)window, refreshOnShow);
        }

        public TransactionCRUDWindow getWindow() {
            return (TransactionCRUDWindow)super.getWindow();
        }

        @Override
        public Party getCustomer() {
            return this.getWindow().getCustomer();
        }

        @Override
        protected void onDoubleClick() {
            this.getWindow().view();
        }
    }

    protected class AccountTab
    extends Tab {
        public AccountTab(Browser<FinancialAct> browser, AccountActCRUDWindow window) {
            super(browser, (AbstractCRUDWindow<FinancialAct>)window);
        }

        public AccountTab(Browser<FinancialAct> browser, ResultSetCRUDWindow<FinancialAct> window, boolean refreshOnShow) {
            super(browser, (AbstractCRUDWindow<FinancialAct>)window, refreshOnShow);
        }

        @Override
        public Party getCustomer() {
            return this.getWindow().getCustomer();
        }

        public AccountActCRUDWindow getWindow() {
            return (AccountActCRUDWindow)super.getWindow();
        }

        @Override
        protected void onDoubleClick() {
            this.getWindow().view();
        }
    }

    protected abstract class Tab
    extends BrowserCRUDWindowTab<FinancialAct> {
        public Tab(Browser<FinancialAct> browser, AbstractCRUDWindow<FinancialAct> window) {
            super(browser, window);
        }

        public Tab(Browser<FinancialAct> browser, AbstractCRUDWindow<FinancialAct> window, boolean refreshOnShow) {
            super(browser, window, refreshOnShow);
        }

        public void show() {
            super.show();
            AccountReportingWorkspace.this.firePropertyChange("summary", null, null);
        }

        public Component getComponent() {
            return SplitPaneFactory.create((int)6, (String)"CRUDWindow", (Component[])new Component[]{this.getWindow().getComponent(), this.getBrowser().getComponent()});
        }

        public abstract Party getCustomer();

        protected void select(FinancialAct object) {
            boolean refresh = this.refreshSummary(object);
            super.select((IMObject)object);
            if (refresh) {
                AccountReportingWorkspace.this.firePropertyChange("summary", null, null);
            }
        }

        protected void refreshBrowser(FinancialAct object) {
            boolean refresh = this.refreshSummary(object);
            super.refreshBrowser((IMObject)object);
            if (refresh) {
                AccountReportingWorkspace.this.firePropertyChange("summary", null, null);
            }
        }

        protected abstract void onDoubleClick();

        private boolean refreshSummary(FinancialAct object) {
            FinancialAct current = (FinancialAct)this.getWindow().getObject();
            return AccountReportingWorkspace.this.getSelected() == this && current != object || object == null;
        }
    }
}

