/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.LocationActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;

public class AccountActResultSet
extends LocationActResultSet<FinancialAct> {
    private final BigDecimal amountFrom;
    private final BigDecimal amountTo;

    public AccountActResultSet(ShortNameConstraint archetypes, String value, Party location, List<Party> locations, Date from, Date to, User clinician, BigDecimal amountFrom, BigDecimal amountTo, String[] statuses, boolean exclude, int pageSize, SortConstraint[] sort) {
        super(archetypes, value, AccountActResultSet.getParticipants(clinician), location, locations, from, to, statuses, exclude, pageSize, sort);
        this.amountFrom = amountFrom;
        this.amountTo = amountTo;
    }

    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        if (this.amountFrom != null || this.amountTo != null) {
            if (this.amountFrom != null && this.amountTo != null) {
                if (this.amountFrom.compareTo(this.amountTo) == 0) {
                    query.add((IConstraint)Constraints.eq((String)"amount", (Object)this.amountFrom));
                } else {
                    query.add((IConstraint)Constraints.between((String)"amount", (Object)this.amountFrom, (Object)this.amountTo));
                }
            } else if (this.amountFrom != null) {
                query.add((IConstraint)Constraints.gte((String)"amount", (Object)this.amountFrom));
            } else {
                query.add((IConstraint)Constraints.lte((String)"amount", (Object)this.amountTo));
            }
        }
        return query;
    }

    protected void addValueConstraints(ArchetypeQuery query) {
        String value = this.getValue();
        if (value != null) {
            query.add((IConstraint)Constraints.leftJoin((String)"customer").add((IConstraint)Constraints.leftJoin((String)"entity", (String)"cust")));
        }
        super.addValueConstraints(query);
    }

    protected List<IConstraint> createValueConstraints(String value, List<String> nodes) {
        List result = super.createValueConstraints(value, nodes);
        result.add(Constraints.eq((String)"cust.name", (Object)value));
        return result;
    }

    private static ParticipantConstraint[] getParticipants(User clinician) {
        ParticipantConstraint[] participantConstraintArray;
        if (clinician != null) {
            ParticipantConstraint[] participantConstraintArray2 = new ParticipantConstraint[1];
            participantConstraintArray = participantConstraintArray2;
            participantConstraintArray2[0] = new ParticipantConstraint("clinician", "participation.clinician", (Entity)clinician);
        } else {
            participantConstraintArray = null;
        }
        return participantConstraintArray;
    }
}

