/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.clinician.ClinicianSelectField;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.query.AbstractQueryState;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.account.AccountActResultSet;

public abstract class AccountActQuery
extends DateRangeActQuery<FinancialAct> {
    private final boolean searchFilter;
    private final boolean amountFilter;
    private final LocationSelectField locationSelector;
    private final SelectField clinicianSelector;
    private final Property fromAmount = new SimpleProperty("amountFrom", BigDecimal.class);
    private final Property toAmount = new SimpleProperty("amountTo", BigDecimal.class);
    private final ModifiableListener fromAmountListener;
    private final ModifiableListener toAmountListener;
    private final int dateRangeMonths = 6;

    public AccountActQuery(String[] archetypes, ActStatuses statuses, Party location, boolean searchFilter, boolean clinicianFilter, boolean amountFilter, LayoutContext context) {
        super(null, null, null, archetypes, statuses, FinancialAct.class);
        this.searchFilter = searchFilter;
        this.amountFilter = amountFilter;
        this.locationSelector = this.createLocationSelector(context.getContext(), location);
        SelectField selectField = this.clinicianSelector = clinicianFilter ? this.createClinicianSelector() : null;
        if (amountFilter) {
            this.setDefaultSortConstraint(ASCENDING_START_TIME);
            this.fromAmountListener = modifiable -> this.onAmountFromChanged();
            this.fromAmount.addModifiableListener(this.fromAmountListener);
            this.toAmountListener = modifiable -> this.onAmountToChanged();
            this.toAmount.addModifiableListener(this.toAmountListener);
        } else {
            this.fromAmountListener = null;
            this.toAmountListener = null;
        }
    }

    public void setLocation(Party location) {
        this.locationSelector.setSelected(location != null ? new Location(location) : Location.ALL);
    }

    public User getClinician() {
        return this.clinicianSelector != null ? (User)this.clinicianSelector.getSelectedItem() : null;
    }

    public void setClinician(User clinician) {
        if (this.clinicianSelector != null) {
            this.clinicianSelector.setSelectedItem((Object)clinician);
        }
    }

    public Extent getHeight() {
        int height = 2;
        if (this.searchFilter || this.amountFilter || this.clinicianSelector != null) {
            ++height;
        }
        return super.getHeight(height);
    }

    public ResultSet<FinancialAct> query(SortConstraint[] sort) {
        ResultSet<FinancialAct> result = null;
        if (this.haveAmount()) {
            DateRange range = this.getDateRange();
            if (range.getAllDates()) {
                ErrorHelper.show((String)Messages.get((String)"reporting.account.search.dateRangeRequired"));
            } else if (range.getFrom() == null || range.getTo() == null || this.calculateFromDate(range.getTo()).compareTo(range.getFrom()) > 0) {
                ErrorHelper.show((String)Messages.format((String)"reporting.account.search.dateRangeTooBig", (Object[])new Object[]{6}));
            } else {
                result = this.createResultSet(sort);
            }
        } else {
            result = this.createResultSet(sort);
        }
        return result;
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        if (this.searchFilter) {
            this.addSearchField(container);
        }
        this.addShortNameSelector(container);
        this.addStatusSelector(container);
        this.addDateRange(container);
        this.addLocation(container);
        if (this.clinicianSelector != null) {
            this.addClinician(container);
        }
        if (this.amountFilter) {
            this.addAmount(container);
        }
    }

    protected ResultSet<FinancialAct> createResultSet(SortConstraint[] sort) {
        return new AccountActResultSet(this.getArchetypeConstraint(), this.getValue(), this.getLocation(), this.getLocations(), this.getFrom(), this.getTo(), this.getClinician(), this.fromAmount.getBigDecimal(), this.toAmount.getBigDecimal(), this.getStatuses(), this.excludeStatuses(), this.getMaxResults(), sort);
    }

    protected List<Party> getLocations() {
        return this.locationSelector.getLocations();
    }

    protected Party getLocation() {
        return (Party)this.locationSelector.getSelectedItem();
    }

    protected LocationSelectField createLocationSelector(Context context, Party location) {
        LocationSelectField result = new LocationSelectField(context.getUser(), context.getPractice(), true);
        if (location != null) {
            result.setSelectedItem((Object)location);
        }
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AccountActQuery.this.onQuery();
            }
        });
        return result;
    }

    protected void addLocation(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (String)"location", (ArchetypeService)ServiceHelper.getArchetypeService()));
        container.add((Component)label);
        container.add((Component)this.locationSelector);
        this.getFocusGroup().add((Component)this.locationSelector);
    }

    protected void addClinician(Component container) {
        Label label = LabelFactory.create();
        label.setText(Messages.get((String)"label.clinician"));
        container.add((Component)label);
        container.add((Component)this.clinicianSelector);
        this.getFocusGroup().add((Component)this.clinicianSelector);
    }

    protected void addAmount(Component container) {
        String amount = DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (String)"amount", (ArchetypeService)ServiceHelper.getArchetypeService());
        Row amountRange = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        int numericLength = StyleSheetHelper.getNumericLength();
        TextField from = BoundTextComponentFactory.createNumeric((Property)this.fromAmount, (int)numericLength);
        TextField to = BoundTextComponentFactory.createNumeric((Property)this.toAmount, (int)numericLength);
        amountRange.add((Component)from);
        amountRange.add((Component)LabelFactory.text((String)"-"));
        amountRange.add((Component)to);
        container.add((Component)LabelFactory.text((String)amount));
        container.add((Component)amountRange);
        FocusGroup group = this.getFocusGroup();
        group.add((Component)from);
        group.add((Component)to);
    }

    public QueryState getQueryState() {
        return new Memento(this);
    }

    public void setQueryState(QueryState state) {
        if (state instanceof Memento) {
            Memento memento = (Memento)state;
            this.setShortName(memento.archetype);
            this.setStatus(memento.status);
            this.getDateRange().setAllDates(memento.all);
            this.getDateRange().setFrom(memento.from);
            this.getDateRange().setTo(memento.to);
            this.setLocation(memento.location);
            this.setClinician(memento.clinician);
            this.fromAmount.setValue((Object)memento.fromAmount);
            this.toAmount.setValue((Object)memento.toAmount);
        }
    }

    private SelectField createClinicianSelector() {
        ClinicianSelectField result = new ClinicianSelectField();
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AccountActQuery.this.onQuery();
            }
        });
        return result;
    }

    private void onAmountToChanged() {
        BigDecimal from = this.fromAmount.getBigDecimal();
        BigDecimal to = this.toAmount.getBigDecimal();
        if (to != null) {
            this.getDateRange().setAllDates(false);
            if (from == null || to.compareTo(from) < 0) {
                this.fromAmount.removeModifiableListener(this.fromAmountListener);
                this.fromAmount.setValue((Object)to);
                this.fromAmount.addModifiableListener(this.fromAmountListener);
            }
        }
    }

    private void onAmountFromChanged() {
        BigDecimal from = this.fromAmount.getBigDecimal();
        BigDecimal to = this.toAmount.getBigDecimal();
        if (from != null) {
            this.getDateRange().setAllDates(false);
            if (to == null || to.compareTo(from) < 0) {
                this.toAmount.removeModifiableListener(this.toAmountListener);
                this.toAmount.setValue((Object)from);
                this.toAmount.addModifiableListener(this.toAmountListener);
            }
        }
    }

    private Date calculateFromDate(Date to) {
        return DateRules.getDate((Date)to, (int)-6, (DateUnits)DateUnits.MONTHS);
    }

    private boolean haveAmount() {
        return this.fromAmount.getBigDecimal() != null || this.toAmount.getBigDecimal() != null;
    }

    private static class Memento
    extends AbstractQueryState {
        private final String archetype;
        private final String status;
        private final boolean all;
        private final Date from;
        private final Date to;
        private final Party location;
        private final User clinician;
        private final BigDecimal fromAmount;
        private final BigDecimal toAmount;

        public Memento(AccountActQuery query) {
            super((Query)query);
            this.archetype = query.getShortName();
            LookupField status = query.getStatusSelector();
            this.status = status != null ? status.getSelectedCode() : null;
            this.all = query.getAllDates();
            this.from = query.getFrom();
            this.to = query.getTo();
            this.location = query.getLocation();
            this.clinician = query.getClinician();
            this.fromAmount = query.fromAmount.getBigDecimal();
            this.toAmount = query.toAmount.getBigDecimal();
        }
    }
}

