/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.io;

import java.util.Date;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.ArchetypeLookupQuery;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.product.io.ProductExportResultSet;

public class ProductExportQuery
extends ProductQuery {
    private final String[] PRICE_LABELS = new String[]{Messages.get((String)"product.export.prices.current"), Messages.get((String)"product.export.prices.all"), Messages.get((String)"product.export.prices.range")};
    private DateRange range;
    private String incomeType;
    private String productGroup;
    private Prices prices = Prices.CURRENT;
    private CheckBox includeLinkedPrices;
    private static final String[] SHORT_NAMES = new String[]{"product.medication", "product.service", "product.merchandise", "product.priceTemplate"};
    private static final Prices[] PRICES = new Prices[]{Prices.CURRENT, Prices.ALL, Prices.RANGE};

    public ProductExportQuery(Context context) {
        super(SHORT_NAMES, context);
        this.setPricingGroup(PricingGroup.ALL);
    }

    public Prices getPrices() {
        return this.prices;
    }

    public void setPrices(Prices prices) {
        this.prices = prices;
        if (this.range != null) {
            this.range.setEnabled(prices == Prices.RANGE);
        }
    }

    public Date getFrom() {
        return this.range != null ? this.range.getFrom() : null;
    }

    public Date getTo() {
        return this.range != null ? this.range.getTo() : null;
    }

    public boolean includeLinkedPrices() {
        return this.includeLinkedPrices.isSelected();
    }

    public Extent getHeight() {
        return this.getHeight(4);
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        this.addSpeciesSelector(container);
        this.addIncomeTypeSelector(container);
        this.addProductGroupSelector(container);
        this.addPriceSelector(container);
        this.addDateRange(container);
        this.addLinkedPrices(container);
        this.addPricingGroupSelector(container, true);
    }

    protected ResultSet<Product> createResultSet(SortConstraint[] sort) {
        return new ProductExportResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), this.getProductType(), this.getSpecies(), this.getStockLocation(), this.incomeType, this.productGroup, sort, this.getMaxResults());
    }

    private void addSpeciesSelector(Component container) {
        ArchetypeLookupQuery query = new ArchetypeLookupQuery("lookup.species");
        final SelectField field = SelectFieldFactory.create((ListModel)new LookupListModel((LookupQuery)query, true));
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductExportQuery.this.setSpecies((String)field.getSelectedItem());
            }
        });
        field.setCellRenderer((ListCellRenderer)LookupListCellRenderer.INSTANCE);
        Label species = LabelFactory.create((String)"product.export.species");
        container.add((Component)species);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addIncomeTypeSelector(Component container) {
        ArchetypeLookupQuery query = new ArchetypeLookupQuery("lookup.productIncomeType");
        final SelectField field = SelectFieldFactory.create((ListModel)new LookupListModel((LookupQuery)query, true));
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductExportQuery.this.incomeType = (String)field.getSelectedItem();
            }
        });
        field.setCellRenderer((ListCellRenderer)LookupListCellRenderer.INSTANCE);
        Label label = LabelFactory.create((String)"product.export.incomeType");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addProductGroupSelector(Component container) {
        ArchetypeLookupQuery query = new ArchetypeLookupQuery("lookup.productGroup");
        final SelectField field = SelectFieldFactory.create((ListModel)new LookupListModel((LookupQuery)query, true));
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductExportQuery.this.productGroup = (String)field.getSelectedItem();
            }
        });
        field.setCellRenderer((ListCellRenderer)LookupListCellRenderer.INSTANCE);
        Label label = LabelFactory.create((String)"product.export.productGroup");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addPriceSelector(Component container) {
        final SelectField field = SelectFieldFactory.create((Object[])PRICES);
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ProductExportQuery.this.setPrices((Prices)((Object)field.getSelectedItem()));
            }
        });
        field.setCellRenderer(new ListCellRenderer(){

            public Object getListCellRendererComponent(Component list, Object value, int index) {
                return ProductExportQuery.this.PRICE_LABELS[index];
            }
        });
        container.add((Component)LabelFactory.create((String)"product.export.prices"));
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addDateRange(Component container) {
        this.range = new DateRange(false);
        this.range.setContainer(container);
        this.range.setEnabled(this.prices == Prices.RANGE);
        this.getFocusGroup().add(this.range.getFocusGroup());
    }

    private void addLinkedPrices(Component container) {
        this.includeLinkedPrices = CheckBoxFactory.create();
        this.includeLinkedPrices.setSelected(false);
        container.add((Component)LabelFactory.create((String)"product.export.includeLinkedPrices"));
        container.add((Component)this.includeLinkedPrices);
        this.getFocusGroup().add((Component)this.includeLinkedPrices);
    }

    public static enum Prices {
        CURRENT,
        ALL,
        RANGE;

    }
}

