/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.vetcheck;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckDialog;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckRules;

public class VetCheckSummary {
    private final Party patient;
    private final VetCheckRules rules;
    private final Column container;
    private final Button button;

    private VetCheckSummary(Party patient, Context context, HelpContext help, VetCheckRules rules) {
        this.patient = patient;
        this.rules = rules;
        this.container = ColumnFactory.create();
        this.button = ButtonFactory.create(null, (String)"button.vetcheck", () -> {
            VetCheckDialog dialog = new VetCheckDialog(patient, context.getLocation(), context, help);
            dialog.show();
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    VetCheckSummary.this.refresh();
                }
            });
        });
        this.button.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
        this.refresh();
    }

    public Component getComponent() {
        return this.container;
    }

    public static Component getSummary(Party patient, Context context, HelpContext help) {
        Component result = null;
        VetCheckRules rules = (VetCheckRules)ServiceHelper.getBean(VetCheckRules.class);
        if (rules.isVetCheckEnabled()) {
            VetCheckSummary summary = new VetCheckSummary(patient, context, help, rules);
            result = summary.getComponent();
        }
        return result;
    }

    private void refresh() {
        this.container.removeAll();
        this.container.add((Component)this.button);
        for (Act act : this.rules.getMostRecentLinks(this.patient, 3)) {
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
            String url = bean.getString("url");
            String description = bean.getString("description");
            if (url == null || description == null) continue;
            Button link = ButtonFactory.text((String)description, () -> this.launch(url));
            link.setStyleName("hyperlink");
            this.container.add((Component)link);
        }
    }

    private void launch(String url) {
        ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(url, "", ""));
    }
}

