/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr.prescription;

import java.util.Objects;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductHelper;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.DefaultEditorQueue;
import org.openvpms.web.workspace.customer.charge.EditorQueue;

public class PrescriptionDispenser {
    private final Context context;
    private final HelpContext help;
    private final CustomerAccountRules rules;

    public PrescriptionDispenser(Context context, HelpContext help) {
        this.context = context;
        this.help = help;
        this.rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
    }

    public void dispense(Act prescription, Party customer, Runnable completionListener) {
        Prescription state = this.prepare(prescription);
        if (state != null) {
            IMObjectBean invoiceBean;
            FinancialAct invoice = this.rules.getInvoice(customer);
            Party location = null;
            if (invoice == null) {
                invoice = (FinancialAct)IMObjectCreator.create((String)"act.customerAccountChargesInvoice");
                invoiceBean = IMObjectHelper.getBean((IMObject)invoice);
                invoiceBean.setTarget("customer", (IMObject)customer);
            } else {
                invoiceBean = IMObjectHelper.getBean((IMObject)invoice);
                location = (Party)invoiceBean.getTarget("location", Party.class);
            }
            if (location == null) {
                location = this.context.getLocation();
            }
            if (this.checkDispense(state.getProduct(), location)) {
                DefaultLayoutContext layout = new DefaultLayoutContext((Context)new LocalContext(this.context), this.help);
                layout.setEdit(true);
                DefaultCustomerChargeActEditor editor = new DefaultCustomerChargeActEditor(invoice, null, (LayoutContext)layout, false);
                editor.getComponent();
                this.dispense(state, (CustomerChargeActEditor)editor, completionListener);
            }
        }
    }

    public void dispense(Act prescription, CustomerChargeActEditor editor, Runnable completionListener) {
        Prescription state = this.prepare(prescription);
        if (state != null) {
            Party location = editor.getLocation();
            if (this.checkDispense(state.getProduct(), location)) {
                this.dispense(state, editor, completionListener);
            }
        }
    }

    protected CustomerChargeActItemEditor dispense(Prescription prescription, final CustomerChargeActEditor editor, final Runnable completionListener) {
        CustomerChargeActItemEditor result = null;
        if (!editor.isValid()) {
            this.errorSaveInvoice();
        } else {
            final CustomerChargeActItemEditor item = editor.addItem();
            if (item == null) {
                this.errorSaveInvoice();
            } else {
                item.getComponent();
                item.setPromptForPrescriptions(false);
                item.setCancelPrescription(true);
                item.getPrescriptions().add(prescription.getAct());
                final EditorQueue existing = item.getEditorQueue();
                item.setEditorQueue(new DefaultEditorQueue(this.context){

                    @Override
                    protected void completed() {
                        super.completed();
                        item.setEditorQueue(existing);
                        SaveHelper.save((IMObjectEditor)editor);
                        if (completionListener != null) {
                            completionListener.run();
                        }
                    }

                    @Override
                    protected void cancelled() {
                        super.cancelled();
                        editor.removeItem((Act)item.getObject());
                    }
                });
                item.setPatient(prescription.getPatient());
                item.setProduct(prescription.getProduct());
            }
            result = item;
        }
        return result;
    }

    private void errorSaveInvoice() {
        ErrorHelper.show((String)Messages.get((String)"patient.prescription.dispense"), (String)Messages.get((String)"patient.prescription.saveinvoice"));
    }

    private boolean checkDispense(Product product, Party location) {
        boolean result = false;
        if (!this.canDispense(product, location)) {
            if (!Objects.equals(location, this.context.getLocation())) {
                ErrorHelper.show((String)Messages.format((String)"patient.prescription.notatinvoicelocation", (Object[])new Object[]{product.getName(), location.getName()}));
            } else {
                ErrorHelper.show((String)Messages.format((String)"patient.prescription.notatlocation", (Object[])new Object[]{product.getName()}));
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean canDispense(Product product, Party location) {
        boolean result;
        if (ProductHelper.useLocationProducts((Context)this.context)) {
            LocationRules locationRules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
            StockRules rules = (StockRules)ServiceHelper.getBean(StockRules.class);
            Party stockLocation = locationRules.getDefaultStockLocation(location);
            result = stockLocation != null && rules.hasStockRelationship(product, stockLocation);
        } else {
            result = true;
        }
        return result;
    }

    private Prescription prepare(Act prescription) {
        Prescription result = null;
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)prescription);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (patient == null) {
            throw new IllegalStateException("Prescription has no patient");
        }
        Product product = (Product)bean.getTarget("product", Product.class);
        if (product == null || !product.isActive()) {
            ErrorHelper.show((String)Messages.get((String)"patient.prescription.productinactive"));
        } else {
            result = new Prescription(prescription, patient, product);
        }
        return result;
    }

    protected static class Prescription {
        private final Act act;
        private final Party patient;
        private final Product product;

        public Prescription(Act act, Party patient, Product product) {
            this.act = act;
            this.patient = patient;
            this.product = product;
        }

        public Act getAct() {
            return this.act;
        }

        public Product getProduct() {
            return this.product;
        }

        public Party getPatient() {
            return this.patient;
        }
    }
}

