/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.bound.BoundTextArea;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.SingleParticipationCollectionEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.act.ActLayoutStrategy;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryDatingPolicy;
import org.openvpms.web.workspace.patient.mr.AbstractPatientClinicalActEditor;
import org.openvpms.web.workspace.patient.mr.PatientNoteEditor;

public class PatientVisitNoteEditor
extends AbstractPatientClinicalActEditor {
    private final PatientNoteEditor noteEditor;
    private final SingleParticipationCollectionEditor clinicianEditor;

    public PatientVisitNoteEditor(Act event, LayoutContext context) {
        this(event, null, context);
    }

    private PatientVisitNoteEditor(Act event, Act existingNote, LayoutContext context) {
        super(event, null, "COMPLETED", context);
        if (!event.isA("act.patientClinicalEvent")) {
            throw new IllegalArgumentException("Invalid argument 'event': " + event.getArchetype());
        }
        if (existingNote != null && !existingNote.isA("act.patientClinicalNote")) {
            throw new IllegalArgumentException("Invalid argument 'existingNote': " + existingNote.getArchetype());
        }
        this.initParticipant("location", (IMObject)context.getContext().getLocation());
        ActRelationshipCollectionEditor items = this.createItemsEditor(event, this.getCollectionProperty("items"));
        List acts = items.getActs();
        Act note = null;
        if (existingNote != null) {
            int index = acts.indexOf(existingNote);
            if (index != -1) {
                note = (Act)acts.get(index);
            } else {
                note = existingNote;
                items.add((IMObject)note);
            }
        }
        if (note == null) {
            note = (Act)items.create("act.patientClinicalNote");
            if (note == null) {
                throw new IllegalStateException("Failed to create act.patientClinicalNote");
            }
            items.add((IMObject)note);
        }
        this.noteEditor = (PatientNoteEditor)items.getEditor(note);
        this.addEditor((Editor)this.noteEditor);
        this.clinicianEditor = new SingleParticipationCollectionEditor(this.noteEditor.getCollectionProperty("clinician"), (IMObject)this.noteEditor.getObject(), context);
        this.clinicianEditor.addModifiableListener(modifiable -> this.setParticipant("clinician", this.noteEditor.getClinicianRef()));
        Property noteStartTime = this.noteEditor.getProperty("startTime");
        noteStartTime.addModifiableListener(modifiable -> this.setStartTime(this.noteEditor.getStartTime()));
    }

    public String getNote() {
        return this.noteEditor.getNote();
    }

    public void setNote(String note) {
        this.noteEditor.setNote(note);
    }

    public IMObjectEditor newInstance() {
        Act event = (Act)this.reload((IMObject)this.getObject());
        Act note = (Act)this.reload((IMObject)this.noteEditor.getObject());
        if (event.isNew() || note.isNew()) {
            IMObjectBean bean = this.getBean((IMObject)event);
            Relationship relationship = bean.removeTarget("items", (IMObject)note);
            note.removeActRelationship((ActRelationship)relationship);
        }
        return new PatientVisitNoteEditor(event, note, this.getLayoutContext());
    }

    public String getDisplayName() {
        return Messages.get((String)"patient.record.summary.visitandnote");
    }

    protected PatientNoteEditor getNoteEditor() {
        return this.noteEditor;
    }

    protected boolean doValidation(Validator validator) {
        if (this.getParticipantRef("clinician") == null) {
            this.setParticipant("clinician", (Reference)((IMObjectReference)null));
        }
        return super.doValidation(validator);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    private class LayoutStrategy
    extends ActLayoutStrategy {
        LayoutStrategy() {
            super(false);
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            ArchetypeNodes nodes = ArchetypeNodes.none().simple(new String[]{"reason", "title"});
            this.setArchetypeNodes(nodes);
            return super.apply(object, properties, parent, context);
        }

        protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
            ComponentSet set = this.createComponentSet(object, properties, context);
            Act act = PatientVisitNoteEditor.this.noteEditor.getObject();
            Property startTime = PatientVisitNoteEditor.this.noteEditor.getProperty("startTime");
            PatientHistoryDatingPolicy policy = (PatientHistoryDatingPolicy)ServiceHelper.getBean(PatientHistoryDatingPolicy.class);
            if (!startTime.isReadOnly() && !policy.canEditStartTime(act)) {
                startTime = this.createReadOnly(startTime);
            }
            set.add(0, this.createComponent(startTime, (IMObject)act, context));
            Property note = PatientVisitNoteEditor.this.noteEditor.getText();
            BoundTextArea textArea = new BoundTextArea(note);
            if (note.getMaxLength() != -1) {
                textArea.setMaximumLength(note.getMaxLength());
            }
            textArea.setStyleName("PatientVisitNote.note");
            set.add(new ComponentState((Component)ColumnFactory.create((String)"PatientClinicalNote.inset", (Component[])new Component[]{textArea}), note));
            set.add(new ComponentState((PropertyEditor)PatientVisitNoteEditor.this.clinicianEditor));
            ComponentGrid grid = new ComponentGrid();
            grid.add(set, 1);
            return grid;
        }

        protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
            ComponentGrid grid = this.createGrid(object, properties, context);
            this.addAuditInfo(object, grid, context);
            Grid component = this.createGrid(grid);
            component.setWidth(Styles.FULL_WIDTH);
            component.setColumnWidth(1, new Extent(90, 2));
            container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{component}));
        }
    }
}

