/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.openvpms.archetype.rules.prefs.PreferenceMonitor;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.LocationMonitor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientByCustomerBrowser;
import org.openvpms.web.component.im.patient.PatientByCustomerQuery;
import org.openvpms.web.component.im.query.ActQuery;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.QueryBrowserCRUDWorkspace;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.DoubleClickMonitor;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;
import org.openvpms.web.workspace.patient.PatientRecordCRUDWindow;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.mr.RecordBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemRecordCRUDWindow;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;

public class PatientRecordWorkspace
extends QueryBrowserCRUDWorkspace<Party, Act> {
    private final DoubleClickMonitor click = new DoubleClickMonitor();
    private final LocationMonitor locationMonitor;
    private final Preferences preferences;
    private final PreferenceMonitor monitor;
    private final MandatoryAlerts alerts;
    private HelpContext currentHelp;

    public PatientRecordWorkspace(Context context, Preferences preferences) {
        super("patient.record", context);
        this.setArchetypes(Party.class, new String[]{"party.patient*"});
        this.setChildArchetypes(Act.class, new String[]{"act.patientClinicalEvent"});
        this.setMailContext((MailContext)new CustomerMailContext(context, this.getHelpContext()));
        this.locationMonitor = context instanceof GlobalContext ? new LocationMonitor((GlobalContext)context, party -> this.updateButtons()) : null;
        this.preferences = preferences;
        this.monitor = new PreferenceMonitor(preferences);
        this.monitor.add("entity.preferenceGroupHistory");
        this.alerts = new MandatoryAlerts(context, this.getHelpContext());
    }

    public void setObject(Party object) {
        ContextHelper.setPatient((Context)this.getContext(), (Party)object, (boolean)false);
        super.setObject((IMObject)object);
        this.firePropertyChange("summary", null, null);
    }

    public Component getSummary() {
        CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
        CustomerPatientSummary summary = factory.createCustomerPatientSummary(this.getContext(), this.getRootHelpContext(), this.preferences);
        return summary.getSummary((Party)this.getObject());
    }

    public void show() {
        super.show();
        if (this.locationMonitor != null) {
            this.locationMonitor.register();
        }
        this.updateButtons();
        this.checkPreferences();
        this.alerts.show((Party)this.getObject());
    }

    public void hide() {
        if (this.locationMonitor != null) {
            this.locationMonitor.unregister();
        }
        super.hide();
    }

    public void preferencesChanged() {
        this.checkPreferences();
    }

    public HelpContext getHelpContext() {
        HelpContext result = this.currentHelp;
        return result == null ? this.getRootHelpContext() : result;
    }

    public RecordBrowser getBrowser() {
        return (RecordBrowser)super.getBrowser();
    }

    protected Party getLatest() {
        return (Party)super.getLatest((IMObject)this.getContext().getPatient());
    }

    protected void onSelected(Party object) {
        super.onSelected((IMObject)object);
        this.alerts.show((Party)this.getObject());
    }

    protected Browser<Party> createSelectBrowser(HelpContext help) {
        return new PatientByCustomerBrowser((PatientByCustomerQuery)this.createSelectQuery(), (LayoutContext)new DefaultLayoutContext(this.getContext(), help));
    }

    protected Query<Party> createSelectQuery() {
        return new PatientByCustomerQuery(this.getArchetypes().getShortNames(), this.getContext());
    }

    protected Component createWorkspace() {
        CRUDWindow window = this.getCRUDWindow();
        SplitPane result = window instanceof AbstractPatientHistoryCRUDWindow ? SplitPaneFactory.create((int)6, (String)"PatientRecordWorkspace.SummaryLayout", (Component[])new Component[]{window.getComponent(), this.getBrowser().getComponent()}) : SplitPaneFactory.create((int)5, (String)"PatientRecordWorkspace.Layout", (Component[])new Component[]{this.getBrowser().getComponent(), window.getComponent()});
        return result;
    }

    protected CRUDWindow<Act> createCRUDWindow() {
        CRUDWindow<Act> window = this.getBrowser().createCRUDWindow(this.getContext(), this.getRootHelpContext());
        this.currentHelp = window.getHelpContext();
        return window;
    }

    protected ActQuery<Act> createQuery() {
        return new PatientHistoryQuery((Party)this.getObject(), this.preferences);
    }

    protected Browser<Act> createBrowser(Query<Act> query) {
        RecordBrowser browser = this.createRecordBrowser((Party)this.getObject(), (PatientHistoryQuery)query, this.getContext(), this.getRootHelpContext());
        browser.setListener(this::changeCRUDWindow);
        return browser;
    }

    protected RecordBrowser createRecordBrowser(Party patient, PatientHistoryQuery query, Context context, HelpContext help) {
        RecordBrowser browser = new RecordBrowser(patient, query, context, help);
        browser.getComponent();
        return browser;
    }

    protected void onBrowserSelected(Act act) {
        super.onBrowserSelected((IMObject)act);
        this.updateSelection(act);
        CRUDWindow window = this.getCRUDWindow();
        if (window instanceof AbstractPatientHistoryCRUDWindow) {
            long id;
            long l = id = act != null ? act.getId() : 0L;
            if (this.click.isDoubleClick((Object)id)) {
                if (window.canEdit()) {
                    window.edit();
                } else {
                    ((AbstractPatientHistoryCRUDWindow)window).view();
                }
            }
        }
    }

    protected void onBrowserViewed(Act object) {
        super.onBrowserViewed((IMObject)object);
        this.updateSelection(object);
    }

    protected void onDeleted(Act object) {
        super.onDeleted((IMObject)object);
        RecordBrowser browser = this.getBrowser();
        if (browser.getSelectedBrowser() instanceof AbstractPatientHistoryBrowser) {
            Act event = browser.getEvent((Act)browser.getSelected());
            ((AbstractPatientHistoryCRUDWindow)this.getCRUDWindow()).setEvent(event);
        }
    }

    protected void onBrowserQuery() {
        super.onBrowserQuery();
        CRUDWindow window = this.getCRUDWindow();
        if (window instanceof PatientRecordCRUDWindow) {
            Act event = this.getBrowser().getEvent((Act)window.getObject());
            ((PatientRecordCRUDWindow)window).setEvent(event);
        }
    }

    protected void checkPreferences() {
        if (this.monitor.changed()) {
            this.layoutWorkspace(false);
        }
    }

    protected HelpContext getRootHelpContext() {
        return super.getHelpContext();
    }

    private void changeCRUDWindow() {
        RecordBrowser browser = this.getBrowser();
        CRUDWindow<Act> window = browser.createCRUDWindow(this.getContext(), this.getRootHelpContext());
        this.currentHelp = window.getHelpContext();
        Act selected = (Act)browser.getSelected();
        if (selected != null) {
            window.setObject((IMObject)selected);
        }
        this.setCRUDWindow(window);
        this.setWorkspace(this.createWorkspace());
    }

    private void updateSelection(Act object) {
        CRUDWindow window = this.getCRUDWindow();
        if (window instanceof PatientRecordCRUDWindow) {
            Act event = this.getBrowser().getEvent(object);
            ((PatientRecordCRUDWindow)window).setEvent(event);
        }
        if (window instanceof ProblemRecordCRUDWindow) {
            Act selectedParent = this.getBrowser().getProblems().getSelectedParent();
            ((ProblemRecordCRUDWindow)window).setProblem(selectedParent);
        }
    }

    private void updateButtons() {
        CRUDWindow window;
        if (this.locationMonitor != null && this.getBrowser() != null && this.locationMonitor.changed() && (window = this.getCRUDWindow()) instanceof AbstractCRUDWindow) {
            ((AbstractCRUDWindow)window).refreshButtons();
        }
    }
}

