/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import echopointng.DateField;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.bound.BoundCheckBox;
import org.openvpms.web.component.bound.BoundDateFieldFactory;
import org.openvpms.web.component.im.query.ActQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ComponentHelper;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;

public class PatientPrescriptionQuery
extends ActQuery<Act> {
    private final SimpleProperty allDates = new SimpleProperty("all", (Object)true, Boolean.class, Messages.get((String)"daterange.all"));
    private final SimpleProperty expiryDate;
    private final ComponentState dateField;
    private static final String[] SHORT_NAMES = new String[]{"act.patientPrescription"};
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("startTime", false)};

    public PatientPrescriptionQuery(Party patient) {
        super((Entity)patient, "patient", "participation.patient", SHORT_NAMES, Act.class);
        this.setAuto(true);
        this.setDefaultSortConstraint(DEFAULT_SORT);
        this.expiryDate = new SimpleProperty("expiringAfter", (Object)new Date(), Date.class, Messages.get((String)"patient.prescription.expiringAfter"));
        this.allDates.addModifiableListener(new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                PatientPrescriptionQuery.this.onAllDatesChanged();
            }
        });
        this.dateField = new ComponentState((Component)BoundDateFieldFactory.create((Property)this.expiryDate), (Property)this.expiryDate);
        this.onAllDatesChanged();
    }

    protected void doLayout(Component container) {
        ComponentState all = new ComponentState((Component)new BoundCheckBox((Property)this.allDates), (Property)this.allDates);
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{all.getLabel(), all.getComponent(), this.dateField.getLabel(), this.dateField.getComponent()});
        container.add((Component)row);
        FocusGroup group = this.getFocusGroup();
        group.add(all.getComponent());
        group.add(this.dateField.getComponent());
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        IConstraint times = null;
        if (!this.allDates.getBoolean()) {
            times = QueryHelper.createDateConstraint((String)"endTime", (Date)this.expiryDate.getDate(), null);
        }
        ParticipantConstraint[] participants = new ParticipantConstraint[]{this.getParticipantConstraint()};
        return new ActResultSet(this.getArchetypeConstraint(), participants, times, this.getStatuses(), false, this.getConstraints(), this.getMaxResults(), sort);
    }

    private void onAllDatesChanged() {
        boolean enabled = !this.allDates.getBoolean();
        ComponentHelper.enable((Component)this.dateField.getLabel(), (boolean)enabled);
        ComponentHelper.enable((DateField)((DateField)this.dateField.getComponent()), (boolean)enabled);
    }
}

