/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.mr.prescription.PrescriptionDispenser;

public class PatientPrescriptionCRUDWindow
extends ActCRUDWindow<Act> {
    protected static final String DISPENSE_ID = "button.dispense";
    protected static final String CANCEL_ID = "button.cancelPrescription";

    public PatientPrescriptionCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, (ActActions)new PrescriptionActions(), context, help);
    }

    protected PatientPrescriptionCRUDWindow(Archetypes<Act> archetypes, PrescriptionActions actions, Context context, HelpContext help) {
        super(archetypes, (ActActions)actions, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(DISPENSE_ID, this::onDispense);
        buttons.add(CANCEL_ID, this::onCancel);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        boolean dispense = enable && this.getActions().canDispense((Act)this.getObject());
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(DISPENSE_ID, dispense);
        buttons.setEnabled(CANCEL_ID, dispense);
    }

    protected PrescriptionActions getActions() {
        return (PrescriptionActions)super.getActions();
    }

    protected void onDispense() {
        Context context = this.getContext();
        Act prescription = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (prescription == null || !this.getActions().canDispense(prescription)) {
            ErrorHelper.show((String)Messages.get((String)"patient.prescription.cannotdispense"));
            this.onRefresh(this.getObject());
        } else {
            Party customer = context.getCustomer();
            if (customer == null) {
                ErrorHelper.show((String)Messages.get((String)"patient.prescription.nocustomer"));
            } else {
                PrescriptionDispenser dispenser = new PrescriptionDispenser(context, this.getHelpContext());
                dispenser.dispense(prescription, customer, () -> this.onSaved((Act)this.getObject(), false));
            }
        }
    }

    protected void onCancel() {
        final Act object = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (object == null) {
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getArchetypes().getDisplayName()}));
        } else if (!this.getActions().canDispense(object)) {
            ErrorDialog.show((String)Messages.get((String)"patient.prescription.nocancel"));
        } else {
            ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"patient.prescription.cancel.title"), Messages.get((String)"patient.prescription.cancel.message"), ConfirmationDialog.YES_NO, this.getHelpContext().subtopic("cancel"));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    PrescriptionRules rules = (PrescriptionRules)ServiceHelper.getBean(PrescriptionRules.class);
                    rules.cancel(object);
                    PatientPrescriptionCRUDWindow.this.onSaved(object, false);
                }
            });
            dialog.show();
        }
    }

    protected static class PrescriptionActions
    extends ActActions<Act> {
        private final PrescriptionRules rules = (PrescriptionRules)ServiceHelper.getBean(PrescriptionRules.class);

        public boolean canEdit(Act act) {
            return this.canDispense(act);
        }

        public boolean canDelete(Act prescription) {
            if (this.canDispense(prescription)) {
                IMObjectBean bean = this.getBean((IMObject)prescription);
                return bean.getValues("dispensing").isEmpty();
            }
            return false;
        }

        public boolean canDispense(Act act) {
            return act != null && this.rules.canDispense(act);
        }
    }
}

