/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.doc.DocumentBackedTextNodeEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientActEditor;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.workspace.patient.mr.PatientClinicalNoteLayoutStrategy;

public class PatientNoteEditor
extends PatientActEditor {
    private final DocumentBackedTextNodeEditor editor;
    static final String NOTE = "note";
    static final String DOCUMENT = "document";

    public PatientNoteEditor(DocumentAct act, Act parent, LayoutContext context) {
        super((Act)act, parent, context);
        Property note = this.getProperty(NOTE);
        Property document = this.getProperty(DOCUMENT);
        this.editor = new DocumentBackedTextNodeEditor(act, note, document, context);
    }

    public String getNote() {
        return this.editor.getText().getString();
    }

    public void setNote(String note) {
        this.editor.getText().setValue((Object)note);
    }

    public IMObjectEditor newInstance() {
        return new PatientNoteEditor((DocumentAct)this.reload((IMObject)((DocumentAct)this.getObject())), (Act)this.getParent(), this.getLayoutContext());
    }

    public boolean isModified() {
        return super.isModified() || this.editor.isModified();
    }

    protected Property getText() {
        return this.editor.getText();
    }

    protected void saveObject() {
        this.editor.save(() -> PatientNoteEditor.super.saveObject());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PatientClinicalNoteLayoutStrategy(this.editor.getText());
    }
}

