/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.BoundTextArea;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.DocumentBackedTextProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryDatingPolicy;

public class PatientClinicalNoteLayoutStrategy
extends AbstractLayoutStrategy {
    private final Property note;

    public PatientClinicalNoteLayoutStrategy() {
        this(null);
    }

    public PatientClinicalNoteLayoutStrategy(Property note) {
        this.note = note;
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        if (context.isEdit()) {
            Property startTime = properties.get("startTime");
            PatientHistoryDatingPolicy policy = (PatientHistoryDatingPolicy)ServiceHelper.getBean(PatientHistoryDatingPolicy.class);
            if (!startTime.isReadOnly() && !policy.canEditStartTime((Act)object)) {
                IMObjectComponentFactory factory = context.getComponentFactory();
                this.addComponent(factory.create(this.createReadOnly(startTime), object));
            }
        }
        this.addComponent(this.createNote(object, properties, context, "PatientClinicalNote.note"));
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ComponentGrid grid = this.createGrid(object, properties, context);
        this.addAuditInfo(object, grid, context);
        Grid component = this.createGrid(grid);
        component.setWidth(Styles.FULL_WIDTH);
        component.setColumnWidth(1, new Extent(90, 2));
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{component}));
    }

    protected Component getDefaultFocus(ComponentSet components) {
        return components.getFocusable("note");
    }

    protected ComponentState createNote(IMObject object, PropertySet properties, LayoutContext context, String styleName) {
        Object text = this.note == null ? new DocumentBackedTextProperty((DocumentAct)object, properties.get("note")) : this.note;
        BoundTextArea textArea = new BoundTextArea(text);
        if (text.getMaxLength() != -1) {
            textArea.setMaximumLength(text.getMaxLength());
        }
        if (!context.isEdit()) {
            textArea.setEnabled(false);
        }
        textArea.setStyleName(styleName);
        return new ComponentState((Component)ColumnFactory.create((String)"PatientClinicalNote.inset", (Component[])new Component[]{textArea}), text);
    }
}

