/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.report.ExternalResults;
import org.openvpms.laboratory.report.View;
import org.openvpms.laboratory.report.WebView;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.investigation.InvestigationHelper;

public class ExternalResultsViewer {
    private final long investigationId;
    private final Component component;

    public ExternalResultsViewer(DocumentAct act) {
        this.investigationId = act.getId();
        Button button = ButtonFactory.create(null, (String)"externallink", this::onView);
        button.setToolTipText(Messages.get((String)"investigation.externalResults"));
        this.component = button;
    }

    public Component getComponent() {
        return this.component;
    }

    protected void view(Order order) {
        View view;
        LaboratoryService service = InvestigationHelper.getLaboratoryService(order);
        ExternalResults results = service.getExternalResults(order);
        if (results != null && results.canView() && (view = results.getView()) instanceof WebView) {
            ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(((WebView)view).getUrl(), "", ""));
        }
    }

    private void onView() {
        Order order = InvestigationHelper.getOrder(this.investigationId);
        if (order != null) {
            this.view(order);
        }
    }
}

