/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.policy;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.edit.identity.IdentityCollectionEditor;
import org.openvpms.web.component.im.edit.identity.IdentityEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.policy.PolicyLayoutStrategy;

public class PolicyEditor
extends AbstractActEditor {
    private final InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
    private String savedPolicyNumber;

    public PolicyEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        if (act.isNew()) {
            this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
            this.initParticipant("patient", (IMObject)context.getContext().getPatient());
        }
        this.addStartEndTimeListeners();
        this.savedPolicyNumber = this.rules.getPolicyNumber(act);
    }

    public IMObjectEditor newInstance() {
        return new PolicyEditor((Act)this.reload((IMObject)this.getObject()), this.getParent(), this.getLayoutContext());
    }

    public void setPolicyNumber(String policyNumber) {
        IdentityCollectionEditor editor = (IdentityCollectionEditor)this.getEditor("insurerId");
        IdentityEditor currentEditor = (IdentityEditor)editor.getCurrentEditor();
        if (currentEditor != null) {
            currentEditor.getProperty("identity").setValue((Object)policyNumber);
        } else if (policyNumber != null) {
            ActIdentity identity = (ActIdentity)editor.create();
            identity.setIdentity(policyNumber);
            editor.add((IMObject)identity);
        }
    }

    protected void doSave() {
        String policyNumber;
        Act object = this.getObject();
        if (!(object.isNew() || StringUtils.equals((CharSequence)(policyNumber = this.rules.getPolicyNumber(object)), (CharSequence)this.savedPolicyNumber) || this.rules.canChangePolicyNumber(object))) {
            throw new IllegalStateException("Cannot change policy number as claims have been submitted");
        }
        super.doSave();
        this.savedPolicyNumber = this.rules.getPolicyNumber(object);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PolicyLayoutStrategy();
    }
}

