/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class GapClaimSummary {
    private final GapClaimImpl claim;
    private final BigDecimal paid;
    private final boolean canPayGap;
    private final BigDecimal remainingGap;
    private final BigDecimal refundAmount;
    private final BigDecimal remainingFull;
    private Grid component;

    public GapClaimSummary(GapClaimImpl claim) {
        this(claim, claim.getInvoiceAllocation());
    }

    public GapClaimSummary(GapClaimImpl claim, BigDecimal allocated) {
        this.claim = claim;
        BigDecimal benefit = claim.getBenefitAmount();
        BigDecimal gapAmount = claim.getGapAmount();
        BigDecimal total = claim.getTotal();
        this.paid = allocated;
        GapClaim.GapStatus gapStatus = claim.getGapStatus();
        if (gapStatus != GapClaim.GapStatus.PENDING) {
            boolean bl = this.canPayGap = this.paid.compareTo(gapAmount) <= 0 && !MathRules.isZero((BigDecimal)benefit);
            if (this.canPayGap) {
                this.remainingGap = gapAmount.subtract(this.paid);
                this.refundAmount = BigDecimal.ZERO;
            } else {
                this.remainingGap = BigDecimal.ZERO;
                this.refundAmount = this.paid.compareTo(gapAmount) > 0 ? this.paid.subtract(gapAmount) : BigDecimal.ZERO;
            }
        } else {
            this.canPayGap = false;
            this.remainingGap = BigDecimal.ZERO;
            this.refundAmount = BigDecimal.ZERO;
        }
        this.remainingFull = this.paid.compareTo(total) <= 0 ? total.subtract(this.paid) : BigDecimal.ZERO;
    }

    public Component getComponent() {
        if (this.component == null) {
            ComponentGrid grid = new ComponentGrid();
            this.doLayout(this.claim, grid);
            this.component = grid.createGrid();
        }
        return this.component;
    }

    public BigDecimal getPaid() {
        return this.paid;
    }

    public boolean canPayGap() {
        return this.canPayGap;
    }

    public boolean canRefund() {
        return !MathRules.isZero((BigDecimal)this.refundAmount);
    }

    public boolean canConfirmGap() {
        return this.canRefund() && this.remainingFull.compareTo(BigDecimal.ZERO) > 0;
    }

    public BigDecimal getRemainingGapAmount() {
        return this.remainingGap;
    }

    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public BigDecimal getRemainingFullAmount() {
        return this.remainingFull;
    }

    protected void doLayout(GapClaimImpl claim, ComponentGrid grid) {
        TextComponent benefitAmount;
        if (claim.getGapStatus() == GapClaim.GapStatus.PENDING) {
            TextField field = TextComponentFactory.create((int)20);
            field.setEnabled(false);
            field.setText(Messages.get((String)"patient.insurance.pay.nobenefit"));
            benefitAmount = field;
        } else {
            benefitAmount = this.createAmount(claim.getBenefitAmount());
        }
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        grid.add(new Component[]{this.createLabel(DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (String)"patient", (ArchetypeService)service)), this.createLabel(claim.getPatient().getName())});
        grid.add(new Component[]{this.createLabel(DescriptorHelper.getDisplayName((String)"act.patientInsurancePolicy", (String)"insurer", (ArchetypeService)service)), this.createLabel(claim.getInsurer().getName())});
        grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay.total"), this.createAmount(claim.getTotal())});
        grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay.benefit"), benefitAmount});
        String benefitNotes = claim.getBenefitNotes();
        if (!StringUtils.isEmpty((CharSequence)benefitNotes)) {
            int maxLength = Math.min(benefitNotes.length(), 100);
            TextComponent field = ReadOnlyComponentFactory.getText((String)benefitNotes, (int)20, (int)maxLength, (String)"default");
            grid.add(new Component[]{this.createLabel(DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (String)"benefitNotes", (ArchetypeService)service)), field});
        }
        grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay.gap"), this.createAmount(claim.getGapAmount())});
        grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay.paid"), this.createAmount(this.paid)});
    }

    protected TextComponent createAmount(BigDecimal amount) {
        return TextComponentFactory.createAmount((BigDecimal)amount, (int)10, (boolean)true);
    }

    private Label createLabel(String text) {
        Label label = LabelFactory.create();
        label.setText(text);
        return label;
    }
}

