/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.internal.claim.ClaimImpl;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.insurance.service.ClaimValidationStatus;
import org.openvpms.insurance.service.Declaration;
import org.openvpms.insurance.service.GapClaimAvailability;
import org.openvpms.insurance.service.GapInsuranceService;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.dialog.PopupWindow;
import org.openvpms.web.echo.dialog.SelectionDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.list.KeyListBox;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.CancelClaimDialog;
import org.openvpms.web.workspace.patient.insurance.claim.BenefitDialog;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimBatchPrinter;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimHelper;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimMailer;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimPrintDialog;
import org.openvpms.web.workspace.patient.insurance.claim.GapClaimPaymentRefundWorkflow;
import org.openvpms.web.workspace.patient.insurance.claim.GapPaymentPrompt;

public class ClaimSubmitter {
    private final Context context;
    private final HelpContext help;
    private final IArchetypeService service;
    private final InsuranceServices insuranceServices;
    private final InsuranceFactory factory;
    private static final String ACCEPT_ID = "button.accept";
    private static final String DECLINE_ID = "button.decline";

    public ClaimSubmitter(IArchetypeService service, InsuranceFactory factory, InsuranceServices insuranceServices, Context context, HelpContext help) {
        this.context = context;
        this.help = help;
        this.service = service;
        this.factory = factory;
        this.insuranceServices = insuranceServices;
    }

    public Claim getClaim(Act act) {
        return this.factory.createClaim(act);
    }

    public void submit(ClaimEditor editor, Consumer<Throwable> listener) {
        try {
            if (!Claim.Status.PENDING.isA(editor.getObject().getStatus())) {
                throw new IllegalStateException("Claim must have PENDING status");
            }
            this.prepare(editor, state -> {
                if (state == null) {
                    listener.accept(null);
                } else {
                    this.submit((ClaimState)state, listener);
                }
            });
        }
        catch (Throwable exception) {
            listener.accept(exception);
        }
    }

    public void submit(Act act, Consumer<Throwable> listener) {
        if (!Claim.Status.POSTED.isA(act.getStatus())) {
            throw new IllegalStateException("Claim must have POSTED status");
        }
        if (this.verifyNoDuplicates(act)) {
            Claim claim = this.factory.createClaim(act);
            Party insurer = claim.getPolicy().getInsurer();
            String title = Messages.get((String)"patient.insurance.submit.title");
            if (this.insuranceServices.canSubmit(insurer)) {
                InsuranceService service = this.insuranceServices.getService(insurer);
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.insurance.submit.online", (Object[])new Object[]{insurer.getName(), service.getName()}))).yesNo()).yes(() -> this.submitWithDeclaration(claim, service, listener))).no(() -> listener.accept(null))).show();
            } else {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.insurance.submit.offline", (Object[])new Object[]{insurer.getName()}))).yesNo()).yes(() -> this.runProtected(listener, () -> claim.setStatus(Claim.Status.SUBMITTED)))).no(() -> listener.accept(null))).show();
            }
        } else {
            listener.accept(null);
        }
    }

    public void pay(Act act, Consumer<Throwable> listener) {
        Claim claim = this.getClaim(act);
        if (!(claim instanceof GapClaimImpl)) {
            throw new IllegalArgumentException("Argument 'claim' is not a GapClaim");
        }
        GapClaimImpl gapClaim = (GapClaimImpl)claim;
        Claim.Status status = gapClaim.getStatus();
        GapClaim.GapStatus gapStatus = gapClaim.getGapStatus();
        if ((status == Claim.Status.SUBMITTED || status == Claim.Status.ACCEPTED) && gapStatus == GapClaim.GapStatus.PENDING) {
            this.waitForBenefit(gapClaim, listener);
        } else if (status == Claim.Status.ACCEPTED || status == Claim.Status.PRE_SETTLED) {
            if (gapStatus == GapClaim.GapStatus.RECEIVED) {
                this.promptToPayClaim(gapClaim, false, listener);
            } else if (gapStatus == GapClaim.GapStatus.PAID) {
                this.notifyInsurerOfPayment(gapClaim, listener);
            } else {
                listener.accept(null);
            }
        }
    }

    public void print(Act act, Consumer<Throwable> listener) {
        Claim claim = this.getClaim(act);
        this.print(claim, act, listener);
    }

    public void mail(Act act) {
        Claim claim = this.getClaim(act);
        Attachments attachments = new Attachments(act);
        if (attachments.missingDocuments()) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"patient.insurance.mail.title"))).message(Messages.format((String)"patient.insurance.mail.noattachment", (Object[])new Object[]{attachments.getMissing()}))).yesNo()).yes(() -> this.mail(claim, act, attachments))).show();
        } else {
            this.mail(claim, act, attachments);
        }
    }

    public void cancel(Act act, final Consumer<Throwable> listener) {
        final Claim claim = this.getClaim(act);
        Party insurer = claim.getPolicy().getInsurer();
        String title = Messages.get((String)"patient.insurance.cancel.title");
        if (this.insuranceServices.canSubmit(insurer)) {
            final InsuranceService service = this.getInsuranceService(insurer);
            if (service.canCancel(claim)) {
                String message = Messages.format((String)"patient.insurance.cancel.online", (Object[])new Object[]{service.getName()});
                final CancelClaimDialog dialog = new CancelClaimDialog(title, message, this.help);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        ClaimSubmitter.this.runProtected(listener, () -> service.cancel(claim, dialog.getReason()));
                    }
                });
                dialog.show();
            } else {
                this.info(title, Messages.format((String)"patient.insurance.cancel.unsupported", (Object[])new Object[0]), listener);
            }
        } else {
            String message = Messages.format((String)"patient.insurance.cancel.offline", (Object[])new Object[]{insurer.getName()});
            final CancelClaimDialog dialog = new CancelClaimDialog(title, message, this.help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    ClaimSubmitter.this.runProtected(listener, () -> claim.setStatus(Claim.Status.CANCELLED, dialog.getReason()));
                }

                public void onNo() {
                    listener.accept(null);
                }
            });
            dialog.show();
        }
    }

    public void settle(Act act, Consumer<Throwable> listener) {
        Claim claim = this.getClaim(act);
        Party insurer = claim.getPolicy().getInsurer();
        String title = Messages.get((String)"patient.insurance.settle.title");
        if (this.insuranceServices.canSubmit(insurer)) {
            this.info(title, Messages.format((String)"patient.insurance.settle.online", (Object[])new Object[]{insurer.getName()}), listener);
        } else {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.insurance.settle.offline", (Object[])new Object[]{insurer.getName()}))).yesNo()).yes(() -> this.runProtected(listener, () -> claim.setStatus(Claim.Status.SETTLED)))).no(() -> listener.accept(null))).show();
        }
    }

    public void decline(Act act, Consumer<Throwable> listener) {
        Claim claim = this.getClaim(act);
        Party insurer = claim.getPolicy().getInsurer();
        String title = Messages.get((String)"patient.insurance.decline.title");
        if (this.insuranceServices.canSubmit(insurer)) {
            this.info(title, Messages.format((String)"patient.insurance.decline.online", (Object[])new Object[]{insurer.getName()}), listener);
        } else {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.insurance.decline.offline", (Object[])new Object[]{insurer.getName()}))).yesNo()).yes(() -> this.runProtected(listener, () -> claim.setStatus(Claim.Status.DECLINED)))).no(() -> listener.accept(null))).show();
        }
    }

    protected void confirmSubmit(ClaimState state, String title, Consumer<Throwable> listener) {
        Claim claim = state.getClaim();
        Party insurer = claim.getPolicy().getInsurer();
        InsuranceService service = state.getService();
        if (service != null) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.insurance.submit.online", (Object[])new Object[]{insurer.getName(), service.getName()}))).yesNo()).yes(() -> this.submitOnlineClaim(state, listener))).no(() -> listener.accept(null))).show();
        } else {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.insurance.submit.offline", (Object[])new Object[]{insurer.getName()}))).yesNo()).yes(() -> this.submitOfflineClaim(state, listener))).no(() -> listener.accept(null))).show();
        }
    }

    protected void print(final Claim claim, Act act, final Consumer<Throwable> listener) {
        Attachments attachments = new Attachments(act);
        String message = attachments.missingDocuments() ? Messages.format((String)"patient.insurance.print.noattachment", (Object[])new Object[]{attachments.getMissing()}) : null;
        final Context context = this.createContext((ClaimImpl)claim);
        final ClaimPrintDialog dialog = new ClaimPrintDialog(claim, act, message, attachments.getAttachments(), context, this.help);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                List selected = dialog.getSelected();
                ClaimBatchPrinter printer = new ClaimBatchPrinter(claim, selected, context, ClaimSubmitter.this.help, listener);
                printer.print();
            }

            public void onCancel() {
                listener.accept(null);
            }
        });
        dialog.show();
    }

    protected void prepare(ClaimEditor editor, Consumer<ClaimState> listener) {
        if (editor.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            if (this.verifyNoDuplicates(editor.getObject())) {
                editor.generateAttachments(success -> {
                    ClaimState state = null;
                    boolean generated = success != null && success != false;
                    try {
                        if (generated && this.checkSubmission(editor)) {
                            state = this.createClaimState(editor);
                        }
                    }
                    catch (Throwable exception) {
                        ErrorHelper.show((Throwable)exception);
                    }
                    listener.accept(state);
                });
            } else {
                listener.accept(null);
            }
        } else {
            ErrorHelper.show((String)Messages.get((String)"patient.insurance.submit.title"), (String)Messages.get((String)"patient.insurance.noinvoice"));
            listener.accept(null);
        }
    }

    protected boolean checkSubmission(ClaimEditor editor) {
        boolean canSubmit;
        boolean gapClaim = editor.isGapClaim();
        if (!gapClaim) {
            canSubmit = true;
        } else {
            GapClaimAvailability support = editor.getGapClaimAvailability();
            canSubmit = support.isAvailable();
            if (!canSubmit) {
                String message = support.getMessage();
                if (message == null) {
                    Party insurer = editor.getInsurer();
                    String name = insurer != null ? insurer.getName() : Messages.get((String)"imobject.none");
                    message = Messages.format((String)"patient.insurance.gap.notsupported", (Object[])new Object[]{name});
                }
                InformationDialog.show((String)message);
            }
        }
        return canSubmit;
    }

    protected BenefitDialog createBenefitDialog(GapClaimImpl claim) {
        return new BenefitDialog(claim, this.help.subtopic("benefit"));
    }

    private ClaimState createClaimState(ClaimEditor editor) {
        Claim claim = this.factory.createClaim(editor.getObject());
        Party insurer = claim.getPolicy().getInsurer();
        ClaimValidationStatus status = null;
        InsuranceService service = null;
        if (this.insuranceServices.canSubmit(insurer)) {
            service = this.getInsuranceService(insurer);
            status = service.validate(claim);
        }
        return new ClaimState(editor.getObject(), claim, status, service);
    }

    private void submit(ClaimState state, Consumer<Throwable> listener) {
        String title = Messages.get((String)"patient.insurance.submit.title");
        ClaimValidationStatus status = state.getStatus();
        if (status != null && status.getStatus() == ClaimValidationStatus.Status.ERROR) {
            ErrorHelper.show((String)title, (String)status.getMessage(), () -> listener.accept(null));
        } else if (status != null && status.getStatus() == ClaimValidationStatus.Status.WARNING) {
            String message = Messages.format((String)"patient.insurance.submit.warning", (Object[])new Object[]{status.getMessage()});
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(message)).yesNo()).yes(() -> this.confirmSubmit(state, title, listener))).no(() -> listener.accept(null))).show();
        } else {
            this.confirmSubmit(state, title, listener);
        }
    }

    private boolean verifyNoDuplicates(Act claim) {
        boolean result = true;
        ClaimHelper helper = new ClaimHelper((ArchetypeService)this.service);
        IMObjectBean claimBean = this.service.getBean((IMObject)claim);
        block0: for (Act item : claimBean.getTargets("items", Act.class)) {
            IMObjectBean bean = this.service.getBean((IMObject)item);
            for (Act charge : bean.getTargets("items", Act.class)) {
                Act otherClaim = helper.getClaim(charge, claim);
                if (otherClaim == null) continue;
                result = false;
                String error = Messages.format((String)"patient.insurance.duplicatecharge", (Object[])new Object[]{otherClaim.getId(), DateFormatter.formatDate((Date)otherClaim.getActivityStartTime(), (boolean)false)});
                ErrorHelper.show((String)Messages.get((String)"patient.insurance.submit.title"), (String)error);
                continue block0;
            }
        }
        return result;
    }

    private void notifyInsurerOfPayment(GapClaimImpl gapClaim, Consumer<Throwable> listener) {
        this.runProtected(listener, () -> {
            Party insurer = gapClaim.getPolicy().getInsurer();
            GapInsuranceService service = (GapInsuranceService)this.getInsuranceService(insurer);
            service.notifyPayment((GapClaim)gapClaim);
        });
    }

    private void payOrRefund(final GapClaimImpl claim, BigDecimal amount, boolean payment, BigDecimal paid, final Consumer<Throwable> listener) {
        if (MathRules.isZero((BigDecimal)amount)) {
            this.gapClaimPartOrFullyPaid(claim, paid, listener);
        } else {
            Context local = this.createContext((ClaimImpl)claim);
            final GapClaimPaymentRefundWorkflow workflow = new GapClaimPaymentRefundWorkflow(amount, payment, paid, claim, local, this.help);
            workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

                public void taskEvent(TaskEvent event) {
                    if (event.getTask() == workflow) {
                        GapClaimImpl reloaded = claim.reload();
                        GapClaim.GapStatus status = reloaded.getGapStatus();
                        if (status == GapClaim.GapStatus.PAID) {
                            ClaimSubmitter.this.notifyInsurerOfPayment(reloaded, listener);
                        } else {
                            listener.accept(null);
                        }
                    }
                }
            });
            workflow.start();
        }
    }

    private void gapClaimPartOrFullyPaid(GapClaimImpl claim, BigDecimal paid, Consumer<Throwable> listener) {
        if (paid.compareTo(claim.getTotal()) >= 0) {
            this.runProtected(listener, false, () -> {
                claim.fullyPaid();
                this.notifyInsurerOfPayment(claim, listener);
            });
        } else {
            this.gapPaid(claim, listener);
        }
    }

    private void gapPaid(final GapClaimImpl claim, final Consumer<Throwable> listener) {
        final Party gapLocation = claim.getLocationParty();
        LocationRules rules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        Entity gapBenefitTill = rules.getGapBenefitTill(gapLocation);
        if (gapBenefitTill == null) {
            String title = Messages.get((String)"patient.insurance.pay.till.title");
            String message = Messages.get((String)"patient.insurance.pay.till.message");
            KeyListBox list = new KeyListBox(rules.getTills(gapLocation).toArray());
            list.setStyleName("default");
            list.setHeight(new Extent(10, 64));
            list.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
            final SelectionDialog dialog = new SelectionDialog(title, message, (ListBox)list);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onAction(String action) {
                    Entity till = (Entity)dialog.getSelected();
                    if (till == null) {
                        listener.accept(null);
                    } else {
                        ClaimSubmitter.this.gapPaid(claim, listener, till, gapLocation);
                    }
                }
            });
            dialog.show();
        } else {
            this.gapPaid(claim, listener, gapBenefitTill, gapLocation);
        }
    }

    private void gapPaid(GapClaimImpl claim, Consumer<Throwable> listener, Entity till, Party location) {
        this.runProtected(listener, false, () -> {
            claim.gapPaid(till, location);
            this.notifyInsurerOfPayment(claim, listener);
        });
    }

    private void mail(Claim claim, Act act, Attachments attachments) {
        ClaimMailer claimMailer = new ClaimMailer();
        Context claimContext = this.createContext((ClaimImpl)claim);
        claimMailer.mail(claim, act, attachments.getAttachments(), claimContext, this.help.subtopic("email"), PopupWindow::show);
    }

    private void submitOfflineClaim(ClaimState state, Consumer<Throwable> listener) {
        this.runProtected(listener, false, () -> {
            Claim claim = state.getClaim();
            claim.finalise();
            claim.setStatus(Claim.Status.SUBMITTED);
            this.print(claim, state.getAct(), listener);
        });
    }

    private void submitOnlineClaim(ClaimState state, Consumer<Throwable> listener) {
        this.runProtected(listener, false, () -> {
            Claim claim = state.getClaim();
            claim.finalise();
            this.submitWithDeclaration(claim, state.getService(), listener);
        });
    }

    private void submitWithDeclaration(Claim claim, InsuranceService service, Consumer<Throwable> listener) {
        this.runProtected(listener, false, () -> {
            Declaration declaration = service.getDeclaration(claim);
            if (declaration != null) {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"patient.insurance.declaration.title"))).message(declaration.getText())).button(ACCEPT_ID, () -> this.submitClaimWithDeclaration(claim, declaration, service, listener))).button(DECLINE_ID, () -> listener.accept(null))).show();
            } else if (claim instanceof GapClaimImpl) {
                this.submitGapClaim((GapClaimImpl)claim, (GapInsuranceService)service, null, listener);
            } else {
                service.submit(claim, null);
                listener.accept(null);
            }
        });
    }

    private void submitClaimWithDeclaration(Claim claim, Declaration declaration, InsuranceService service, Consumer<Throwable> listener) {
        if (claim instanceof GapClaim) {
            this.submitGapClaim((GapClaimImpl)claim, (GapInsuranceService)service, declaration, listener);
        } else {
            this.runProtected(listener, () -> service.submit(claim, declaration));
        }
    }

    private void submitGapClaim(GapClaimImpl claim, GapInsuranceService service, Declaration declaration, Consumer<Throwable> listener) {
        this.runProtected(listener, false, () -> {
            service.submit((Claim)claim, declaration);
            this.waitForBenefit(claim, listener);
        });
    }

    private void waitForBenefit(GapClaimImpl claim, final Consumer<Throwable> listener) {
        final BenefitDialog dialog = this.createBenefitDialog(claim);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onClose(WindowPaneEvent event) {
                if ("button.stopwaitingforbenefit".equals(dialog.getAction())) {
                    listener.accept(null);
                } else {
                    GapClaimImpl currentClaim = dialog.getClaim();
                    Claim.Status status = currentClaim.getStatus();
                    if (status == Claim.Status.ACCEPTED) {
                        boolean payFull = "button.payfullclaim".equals(dialog.getAction());
                        ClaimSubmitter.this.promptToPayClaim(currentClaim, payFull, listener);
                    } else if (status == Claim.Status.CANCELLING) {
                        ClaimSubmitter.this.info(Messages.get((String)"patient.insurance.pay.title"), Messages.get((String)"patient.insurance.pay.cancelling"), listener);
                    } else if (status == Claim.Status.CANCELLED) {
                        ClaimSubmitter.this.info(Messages.get((String)"patient.insurance.pay.title"), Messages.get((String)"patient.insurance.pay.cancelled"), listener);
                    } else if (status == Claim.Status.DECLINED) {
                        ClaimSubmitter.this.info(Messages.get((String)"patient.insurance.pay.title"), Messages.get((String)"patient.insurance.pay.declined"), listener);
                    } else {
                        listener.accept(null);
                    }
                }
            }
        });
        dialog.show();
    }

    private void promptToPayClaim(final GapClaimImpl claim, boolean payFullClaim, final Consumer<Throwable> listener) {
        final GapPaymentPrompt dialog = new GapPaymentPrompt(claim, payFullClaim, this.help.subtopic("pay"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                if (dialog.confirmGap()) {
                    ClaimSubmitter.this.gapClaimPartOrFullyPaid(claim, dialog.getPaid(), listener);
                } else if (dialog.refundGap()) {
                    ClaimSubmitter.this.payOrRefund(claim, dialog.getAmountToRefund(), false, dialog.getPaid(), listener);
                } else {
                    ClaimSubmitter.this.payOrRefund(claim, dialog.getAmountToPay(), true, dialog.getPaid(), listener);
                }
            }

            public void onCancel() {
                listener.accept(null);
            }
        });
        dialog.show();
    }

    private void info(String title, String message, Consumer<Throwable> listener) {
        ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(title)).message(message)).listener(() -> listener.accept(null))).show();
    }

    private void runProtected(Consumer<Throwable> listener, Runnable runnable) {
        this.runProtected(listener, true, runnable);
    }

    private void runProtected(Consumer<Throwable> listener, boolean notifyOnSuccess, Runnable runnable) {
        try {
            runnable.run();
            if (notifyOnSuccess) {
                listener.accept(null);
            }
        }
        catch (Throwable exception) {
            listener.accept(exception);
        }
    }

    private InsuranceService getInsuranceService(Party insurer) {
        return this.insuranceServices.getService(insurer);
    }

    private Context createContext(ClaimImpl claim) {
        LocalContext local = new LocalContext(this.context);
        Party insurer = claim.getPolicy().getInsurer();
        local.setCustomer(claim.getCustomer());
        local.setPatient(claim.getPatient());
        local.setSupplier(insurer);
        return local;
    }

    private static class ClaimState {
        private final Act act;
        private final Claim claim;
        private final ClaimValidationStatus status;
        private final InsuranceService service;

        ClaimState(Act act, Claim claim, ClaimValidationStatus status, InsuranceService service) {
            this.act = act;
            this.claim = claim;
            this.status = status;
            this.service = service;
        }

        public Act getAct() {
            return this.act;
        }

        public Claim getClaim() {
            return this.claim;
        }

        public ClaimValidationStatus getStatus() {
            return this.status;
        }

        public InsuranceService getService() {
            return this.service;
        }
    }

    private class Attachments {
        private final List<IMObject> objects;
        private int missing;

        public Attachments(Act claim) {
            IMObjectBean bean = ClaimSubmitter.this.service.getBean((IMObject)claim);
            this.objects = new ArrayList<IMObject>();
            this.objects.add((IMObject)claim);
            this.missing = 0;
            for (DocumentAct attachment : bean.getTargets("attachments", DocumentAct.class)) {
                if (attachment.getDocument() != null) {
                    this.objects.add((IMObject)attachment);
                    continue;
                }
                ++this.missing;
            }
        }

        public List<IMObject> getAttachments() {
            return this.objects;
        }

        public boolean missingDocuments() {
            return this.missing != 0;
        }

        public int getMissing() {
            return this.missing;
        }
    }
}

