/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.StaticDocumentTemplateLocator;

class ClaimHelper {
    private final ArchetypeService service;

    public ClaimHelper(ArchetypeService service) {
        this.service = service;
    }

    public Act getClaim(Act item, Act exclude) {
        Act result = null;
        IMObjectBean chargeBean = this.service.getBean((IMObject)item);
        for (Act claimItem : chargeBean.getSources("claims", Act.class)) {
            String status;
            IMObjectBean bean = this.service.getBean((IMObject)claimItem);
            Act claim = (Act)bean.getSource("claim", Act.class);
            if (claim == null || claim.equals(exclude) || Claim.Status.CANCELLED.isA(status = claim.getStatus())) continue;
            result = claim;
            break;
        }
        return result;
    }

    public DocumentTemplateLocator getDocumentTemplateLocator(Claim claim, IMObject object, Context context) {
        Party insurer;
        IMObjectBean bean;
        Entity template;
        if (object.isA("act.patientInsuranceClaim") && (template = (Entity)(bean = this.service.getBean((IMObject)(insurer = claim.getPolicy().getInsurer()))).getTarget("template", Entity.class, Policies.active())) != null) {
            return new StaticDocumentTemplateLocator(new DocumentTemplate(template, this.service));
        }
        return new ContextDocumentTemplateLocator(object, context);
    }
}

