/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.GapClaimAvailability;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditorFactory;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.claim.AbstractClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimAttachmentGenerator;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimContext;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimLayoutStrategy;
import org.openvpms.web.workspace.patient.insurance.claim.PolicyNumberEditor;

public class ClaimEditor
extends AbstractClaimEditor {
    private final ClaimContext claimContext;
    private final Charges charges;
    private final SimpleProperty insurer = new SimpleProperty("insurer", IMObjectReference.class);
    private final ModifiableListener insurerListener;
    private final IMObjectReferenceEditor<Party> insurerEditor;
    private final ModifiableListener policyNumberListener;
    private final PolicyNumberEditor policyNumberEditor;
    private final AttachmentCollectionEditor attachments;
    private final ClaimItemCollectionEditor items;
    private final ClaimAttachmentGenerator generator;
    private boolean showGapClaim;
    private String gapAlert;

    public ClaimEditor(FinancialAct act, IMObject parent, LayoutContext layoutContext) {
        super((Act)act, parent, "amount", layoutContext);
        Party patient;
        Context context = layoutContext.getContext();
        if (act.isNew()) {
            this.initParticipant("patient", (IMObject)context.getPatient());
            this.initParticipant("location", (IMObject)context.getLocation());
            this.initParticipant("clinician", (IMObject)context.getClinician());
            this.initParticipant("user", (IMObject)context.getUser());
        }
        if ((patient = this.getPatient()) == null) {
            throw new IllegalStateException("Claim has no patient");
        }
        Party customer = context.getCustomer();
        if (customer == null) {
            throw new IllegalStateException("Context has no customer");
        }
        this.claimContext = this.createClaimContext(act, customer, patient, context);
        this.insurer.setRequired(true);
        this.insurer.setArchetypeRange(new String[]{"party.supplierInsurer"});
        this.insurer.setDisplayName(this.getDisplayName("act.patientInsurancePolicy", "insurer"));
        this.insurerEditor = IMObjectReferenceEditorFactory.create((Property)this.insurer, (IMObject)parent, (LayoutContext)layoutContext);
        this.insurerEditor.setObject((IMObject)this.claimContext.getInsurer());
        SimpleProperty policyNumber = new SimpleProperty("policyNumber", String.class);
        policyNumber.setDisplayName(this.getDisplayName("act.patientInsurancePolicy", "insurerId"));
        this.policyNumberEditor = new PolicyNumberEditor((Property)policyNumber, this.claimContext, layoutContext);
        this.attachments = new AttachmentCollectionEditor(this.getCollectionProperty("attachments"), (Act)act, layoutContext);
        this.charges = new Charges(this.claimContext);
        this.items = new ClaimItemCollectionEditor(this.getCollectionProperty("items"), (Act)act, this.claimContext.getCustomer(), patient, this.charges, this.attachments, layoutContext);
        this.addEditor((Editor)this.policyNumberEditor);
        this.addEditor((Editor)this.insurerEditor);
        this.addEditor((Editor)this.attachments);
        this.addEditor((Editor)this.items);
        this.generator = new ClaimAttachmentGenerator(this.claimContext.getCustomer(), patient, this.charges, context);
        this.items.addModifiableListener(modifiable -> this.onItemsChanged());
        for (Act item : this.items.getCurrentActs()) {
            this.items.getEditor((IMObject)item);
        }
        this.insurerListener = modifiable -> this.onInsurerChanged();
        this.insurer.addModifiableListener(this.insurerListener);
        this.policyNumberListener = modifiable -> this.onPolicyNumberChanged();
        this.policyNumberEditor.addModifiableListener(this.policyNumberListener);
    }

    public Party getPatient() {
        return (Party)this.getParticipant("patient");
    }

    public Party getInsurer() {
        return this.claimContext.getInsurer();
    }

    public BigDecimal getAmount() {
        return this.getProperty("amount").getBigDecimal(BigDecimal.ZERO);
    }

    public IMObjectEditor newInstance() {
        ClaimEditor editor = null;
        FinancialAct act = (FinancialAct)this.reload((IMObject)this.getObject());
        if (Claim.Status.PENDING.isA(act.getStatus())) {
            editor = new ClaimEditor(act, this.getParent(), this.getLayoutContext());
        }
        return editor;
    }

    public void generateAttachments(Consumer<Boolean> listener) {
        DefaultValidator validator = new DefaultValidator();
        if (!this.validate((Validator)validator)) {
            ValidationHelper.showError((Validator)validator);
            listener.accept(false);
        } else {
            Party location = this.getLocation();
            if (location != null) {
                this.generator.generate(this.getObject(), this.getInsurer(), this.items, this.attachments, location, listener);
            } else {
                listener.accept(false);
            }
        }
    }

    public void showAttachments() {
        ClaimLayoutStrategy strategy = (ClaimLayoutStrategy)this.getView().getLayout();
        strategy.selectAttachments();
    }

    public boolean checkAttachments() {
        boolean result = true;
        for (Act attachment : this.attachments.getCurrentActs()) {
            if (!Attachment.Status.ERROR.isA(attachment.getStatus())) continue;
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            IMObjectBean bean = service.getBean((IMObject)attachment);
            String error = bean.getString("error");
            ErrorDialog.show((String)Messages.get((String)"patient.insurance.attachments.title"), (String)Messages.format((String)"patient.insurance.attachments.message", (Object[])new Object[]{attachment.getName(), error}));
            result = false;
            break;
        }
        return result;
    }

    public boolean isGapClaim() {
        return this.getProperty("gapClaim").getBoolean();
    }

    public GapClaimAvailability getGapClaimAvailability() {
        return this.claimContext.getGapClaimAvailability();
    }

    public void checkGapClaimAvailability() {
        GapClaimAvailability availability;
        Party insurer = this.getInsurer();
        AlertListener alertListener = this.getAlertListener();
        if (insurer != null && alertListener != null && (availability = this.getGapClaimAvailability()).getMessage() != null) {
            this.notifyGapAlert(availability.getMessage());
        }
    }

    public Act getPolicy() {
        return this.claimContext.getPolicy();
    }

    protected Party getLocation() {
        return (Party)this.getParticipant("location");
    }

    protected ClaimContext createClaimContext(FinancialAct act, Party customer, Party patient, Context context) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        InsuranceServices insuranceServices = (InsuranceServices)ServiceHelper.getBean(InsuranceServices.class);
        InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
        return new ClaimContext(act, customer, patient, this.getLocation(), (IArchetypeService)service, rules, insuranceServices, (InsuranceFactory)ServiceHelper.getBean(InsuranceFactory.class));
    }

    protected ClaimItemCollectionEditor getItems() {
        return this.items;
    }

    protected AttachmentCollectionEditor getAttachments() {
        return this.attachments;
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = this.insurer.validate(validator);
        if (valid) {
            this.claimContext.prepare();
            valid = super.doValidation(validator) && this.validatePolicyCustomer(validator) && this.validateGapClaim(validator) && this.validateInvoices(validator);
        }
        return valid;
    }

    protected void doSave() {
        this.claimContext.save();
        this.saveObject();
        this.saveChildren();
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.attachments.getComponent();
        this.getParticipationEditor("location", false).addModifiableListener(modifiable -> this.onLocationChanged());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        this.showGapClaim = this.isGapClaim() || this.claimContext.supportsGapClaims();
        return new ClaimLayoutStrategy(this.getPatient(), (PropertyEditor)this.insurerEditor, (PropertyEditor)this.policyNumberEditor, this.items, this.attachments, this.showGapClaim);
    }

    @Override
    protected List<Act> getItemActs() {
        return this.items.getActs();
    }

    private boolean validatePolicyCustomer(Validator validator) {
        boolean result = true;
        Party customer = this.claimContext.getCustomer();
        Party policyCustomer = this.claimContext.getPolicyCustomer();
        if (customer != null && policyCustomer != null && !Objects.equals(customer, policyCustomer)) {
            result = false;
            String message = Messages.format((String)"patient.insurance.customermismatch", (Object[])new Object[]{policyCustomer.getName()});
            validator.add((Modifiable)this, new ValidatorError(message));
        }
        return result;
    }

    private boolean validateGapClaim(Validator validator) {
        boolean gapClaim = this.isGapClaim();
        if (gapClaim && !this.claimContext.supportsGapClaims()) {
            Party insurer = this.claimContext.getInsurer();
            String name = insurer != null ? insurer.getName() : null;
            validator.add((Modifiable)this, Messages.format((String)"patient.insurance.gap.notsupported", (Object[])new Object[]{name}));
        }
        return validator.isValid();
    }

    private boolean validateInvoices(Validator validator) {
        List<FinancialAct> invoices = this.charges.getInvoices();
        if (!invoices.isEmpty()) {
            boolean gapClaim = this.isGapClaim();
            boolean fullyPaid = true;
            boolean mustBeFullyClaimed = !this.claimContext.canSubmitPartialInvoices();
            for (FinancialAct invoice : invoices) {
                String message;
                String date;
                String displayName;
                if (!this.charges.canClaimInvoice(invoice)) {
                    displayName = this.getDisplayName((IMObject)invoice);
                    date = DateFormatter.formatDateTime((Date)invoice.getActivityStartTime());
                    message = this.charges.isReversed(invoice) ? Messages.format((String)"patient.insurance.invoice.reversed", (Object[])new Object[]{displayName, date}) : Messages.format((String)"patient.insurance.invoice.unpaid", (Object[])new Object[]{displayName, date});
                    validator.add((Modifiable)this, message);
                    break;
                }
                if (mustBeFullyClaimed && !this.charges.isFullyClaimed(invoice)) {
                    displayName = this.getDisplayName((IMObject)invoice);
                    date = DateFormatter.formatDateTime((Date)invoice.getActivityStartTime());
                    message = Messages.format((String)"patient.insurance.invoice.partiallyclaimed", (Object[])new Object[]{displayName, date});
                    validator.add((Modifiable)this, message);
                    continue;
                }
                if (!gapClaim) continue;
                fullyPaid &= this.charges.isPaid(invoice);
            }
            if (validator.isValid() && gapClaim && fullyPaid) {
                validator.add((Modifiable)this, Messages.get((String)"patient.insurance.invoice.fullypaid"));
            }
        }
        return validator.isValid();
    }

    private void onLocationChanged() {
        this.claimContext.setLocation(this.getLocation());
        this.onLayout();
        this.attachments.deleteGeneratedDocuments();
        this.checkGapClaimAvailability();
    }

    private void notifyGapAlert(String message) {
        AlertListener alertListener = this.getAlertListener();
        if (this.gapAlert != null) {
            alertListener.cancel(this.gapAlert);
        }
        this.gapAlert = alertListener.onAlert(message);
    }

    private void onInsurerChanged() {
        this.claimContext.setInsurer((Party)this.insurerEditor.getObject());
        try {
            this.policyNumberEditor.removeModifiableListener(this.policyNumberListener);
            this.policyNumberEditor.refresh();
        }
        finally {
            this.policyNumberEditor.addModifiableListener(this.policyNumberListener);
        }
        if (this.showGapClaim && !this.isGapClaim() && !this.claimContext.supportsGapClaims() || !this.showGapClaim && this.claimContext.supportsGapClaims()) {
            this.onLayout();
        }
        this.checkGapClaimAvailability();
    }

    private void onPolicyNumberChanged() {
        try {
            this.insurer.removeModifiableListener(this.insurerListener);
            this.insurerEditor.setObject((IMObject)this.claimContext.getInsurer());
        }
        finally {
            this.insurer.addModifiableListener(this.insurerListener);
        }
    }
}

