/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.practice.Location;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.GapClaimAvailability;
import org.openvpms.insurance.service.GapInsuranceService;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;

public class ClaimContext {
    private final IMObjectBean claim;
    private final Party customer;
    private final Party patient;
    private final IArchetypeService service;
    private final InsuranceRules rules;
    private final InsuranceServices insuranceServices;
    private final InsuranceFactory factory;
    private Location location;
    private boolean modified;
    private Act policy;
    private Party policyCustomer;
    private Party insurer;
    private String policyNumber;
    private InsuranceService insuranceService;
    private GapClaimAvailability gapClaimAvailability;

    public ClaimContext(FinancialAct claim, Party customer, Party patient, Party location, IArchetypeService service, InsuranceRules rules, InsuranceServices insuranceServices, InsuranceFactory factory) {
        this.customer = customer;
        this.patient = patient;
        this.service = service;
        this.rules = rules;
        this.insuranceServices = insuranceServices;
        this.factory = factory;
        this.claim = service.getBean((IMObject)claim);
        this.location = this.getLocation(location);
        this.setPolicy((Act)this.claim.getTarget("policy", Act.class));
    }

    public Party getCustomer() {
        return this.customer;
    }

    public Party getPatient() {
        return this.patient;
    }

    public Party getInsurer() {
        return this.insurer;
    }

    public void setInsurer(Party insurer) {
        Act newPolicy;
        Act act = newPolicy = insurer != null ? this.rules.getPolicy(this.customer, this.patient, insurer) : null;
        if (newPolicy != null) {
            this.setPolicy(newPolicy);
        } else {
            this.updateInsurer(insurer);
            this.policy = null;
            this.policyNumber = null;
        }
    }

    public Act getPolicy() {
        return this.policy;
    }

    public void setPolicy(Act policy) {
        Party newInsurer = null;
        String newPolicyNumber = null;
        IMObjectBean bean = this.setPolicyAct(policy);
        if (bean != null) {
            newPolicyNumber = this.getPolicyNumber(bean);
            newInsurer = (Party)bean.getTarget("insurer", Party.class);
        }
        this.policyNumber = newPolicyNumber;
        this.updateInsurer(newInsurer);
    }

    public String getPolicyNumber() {
        return this.policyNumber;
    }

    public boolean setPolicyNumber(String policyNumber) {
        boolean result = false;
        if (!StringUtils.equals((CharSequence)policyNumber, (CharSequence)this.policyNumber)) {
            this.policyNumber = policyNumber;
            this.policy = null;
            result = true;
        }
        return result;
    }

    public Party getPolicyCustomer() {
        return this.policyCustomer;
    }

    public void setLocation(Party location) {
        this.location = this.getLocation(location);
        if (this.location != null) {
            this.updateService();
        }
    }

    public boolean isGapClaim() {
        return this.claim.getBoolean("gapClaim");
    }

    public boolean supportsGapClaims() {
        return this.getGapClaimAvailability().isAvailable();
    }

    public GapClaimAvailability getGapClaimAvailability() {
        if (this.gapClaimAvailability == null) {
            this.gapClaimAvailability = GapClaimAvailability.notAvailable();
        }
        return this.gapClaimAvailability;
    }

    public void prepare() {
        if (this.insurer != null) {
            boolean addRelationship = false;
            if (this.policy == null) {
                Act act = this.rules.getPolicyForClaim(this.customer, this.patient, this.insurer, this.policyNumber, (FinancialAct)this.claim.getObject(), null);
                this.setPolicyAct(act);
                this.modified = true;
            }
            if (!Objects.equals(this.claim.getTargetRef("policy"), this.policy.getObjectReference())) {
                ActRelationship relationship = (ActRelationship)this.claim.setTarget("policy", (IMObject)this.policy);
                this.policy.addActRelationship(relationship);
                addRelationship = true;
            }
            this.modified = this.modified || addRelationship || this.policy.isNew();
        }
    }

    public boolean canSubmitPartialInvoices() {
        return this.insuranceService == null || this.insuranceService.canSubmitPartialInvoices();
    }

    public void save() {
        if (this.modified) {
            this.service.save((IMObject)this.policy);
            this.modified = false;
        }
    }

    protected String getPolicyNumber(IMObjectBean bean) {
        ActIdentity insurerId = (ActIdentity)bean.getObject("insurerId", ActIdentity.class);
        return insurerId != null ? insurerId.getIdentity() : null;
    }

    protected void updateInsurer(Party insurer) {
        this.insurer = insurer;
        this.updateService();
    }

    private IMObjectBean setPolicyAct(Act policy) {
        IMObjectBean bean = null;
        this.policy = policy;
        if (policy != null) {
            bean = this.service.getBean((IMObject)policy);
            this.policyCustomer = (Party)bean.getTarget("customer", Party.class);
        } else {
            this.policyCustomer = null;
        }
        return bean;
    }

    private Location getLocation(Party location) {
        return location != null ? this.factory.getLocation(location) : null;
    }

    private void updateService() {
        InsuranceService newService = null;
        this.gapClaimAvailability = null;
        if (this.insurer != null && this.location != null && (newService = this.insuranceServices.getService(this.insurer)) instanceof GapInsuranceService) {
            try {
                this.gapClaimAvailability = ((GapInsuranceService)newService).getGapClaimAvailability(this.insurer, this.policyNumber, this.location);
            }
            catch (Throwable exception) {
                String message = Messages.format((String)"patient.insurance.gap.notavailable", (Object[])new Object[]{this.insurer.getName(), exception.getMessage()});
                this.gapClaimAvailability = GapClaimAvailability.notAvailable((String)message);
                ErrorHelper.show((Throwable)exception);
            }
        }
        this.insuranceService = newService;
    }
}

