/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.internal.claim.HistoryImpl;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryFilter;
import org.openvpms.web.workspace.patient.history.PatientHistoryIterator;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemCollectionEditor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class ClaimAttachmentGenerator {
    private final Party patient;
    private final Charges charges;
    private final Context context;
    private final InsuranceRules insuranceRules;
    private final ReporterFactory factory;
    private final MedicalRecordRules recordRules;
    private final ArchetypeService service;
    private final ReporterFactory reporterFactory;
    private final DocumentConverter converter;
    private final DocumentJobManager jobManager;
    private final PlatformTransactionManager transactionManager;
    private final DocumentHandlers documentHandlers;
    static final String INSURANCE_CLAIM_INVOICE = "INSURANCE_CLAIM_INVOICE";
    static final String INSURANCE_CLAIM_MEDICAL_RECORDS = "INSURANCE_CLAIM_MEDICAL_RECORDS";

    public ClaimAttachmentGenerator(Party customer, Party patient, Charges charges, Context context) {
        this(customer, patient, charges, context, (DocumentConverter)ServiceHelper.getBean(DocumentConverter.class));
    }

    public ClaimAttachmentGenerator(Party customer, Party patient, Charges charges, Context context, DocumentConverter converter) {
        this.patient = patient;
        this.charges = charges;
        LocalContext local = new LocalContext(context);
        local.setCustomer(customer);
        local.setPatient(patient);
        this.context = local;
        this.insuranceRules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
        this.factory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
        this.recordRules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
        this.service = ServiceHelper.getArchetypeService();
        this.reporterFactory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
        this.converter = converter;
        this.jobManager = (DocumentJobManager)ServiceHelper.getBean(DocumentJobManager.class);
        this.transactionManager = (PlatformTransactionManager)ServiceHelper.getBean(PlatformTransactionManager.class);
        this.documentHandlers = (DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class);
    }

    public void generate(Act claim, Party insurer, ClaimItemCollectionEditor items, AttachmentCollectionEditor attachments, Party location, Consumer<Boolean> listener) {
        this.context.setLocation(location);
        this.updateHistory(attachments);
        this.updateInvoices(attachments);
        Iterator<Act> iterator = attachments.getCurrentActs().iterator();
        this.generate(iterator, claim, insurer, items, attachments, (Boolean success) -> {
            attachments.save();
            attachments.refresh();
            listener.accept((Boolean)success);
        });
    }

    protected void rubJob(Job<org.openvpms.component.model.document.Document> job, String titleKey, String messageKey) {
        this.jobManager.runInteractive(job, Messages.get((String)titleKey), Messages.get((String)messageKey));
    }

    protected PatientHistoryIterator getHistory(Act claim, ClaimItemCollectionEditor items, Party insurer) {
        Date minTreatmentDate = items.getMinTreatmentDate();
        Date maxTreatmentDate = items.getMaxTreatmentDate();
        Date from = null;
        Date to = maxTreatmentDate;
        boolean inclusiveFrom = true;
        boolean inclusiveTo = false;
        if (insurer != null && minTreatmentDate != null) {
            HistoryImpl history = new HistoryImpl(this.patient, insurer, claim, minTreatmentDate, maxTreatmentDate, this.insuranceRules, this.recordRules, this.service);
            from = history.getPriorTreatmentDate();
            to = history.getTreatedTo();
            if (from != null) {
                inclusiveFrom = DateRules.compareTo((Date)from, (Date)history.getTreatedFrom(), (boolean)true) == 0;
            }
            inclusiveTo = history.isTreatedToInclusive();
        }
        ClaimHistoryQuery query = new ClaimHistoryQuery(this.patient, from, inclusiveFrom, to, inclusiveTo);
        PatientHistoryFilter filter = new PatientHistoryFilter(query.getSelectedArchetypes(), this.service);
        return new PatientHistoryIterator((Iterable<Act>)((Object)query), filter, 3);
    }

    private void generate(Iterator<Act> iterator, Act claim, Party insurer, ClaimItemCollectionEditor items, AttachmentCollectionEditor attachments, Consumer<Boolean> listener) {
        if (iterator.hasNext()) {
            Act attachment = iterator.next();
            this.generate(attachment, claim, items, insurer, success -> {
                if (success != null && success.booleanValue()) {
                    attachments.refresh((DocumentAct)attachment);
                    this.generate(iterator, claim, insurer, items, attachments, listener);
                } else {
                    listener.accept(false);
                }
            });
        } else {
            listener.accept(true);
        }
    }

    private void updateHistory(AttachmentCollectionEditor attachments) {
        DocumentAct history = attachments.getHistory();
        if (history != null) {
            attachments.remove((IMObject)history);
        }
        attachments.add((IMObject)attachments.createHistory());
    }

    private void updateInvoices(AttachmentCollectionEditor attachments) {
        Set<Reference> expectedInvoices = this.charges.getInvoiceRefs();
        for (Act attachment : attachments.getCurrentActs()) {
            if (!this.isInvoice(attachment)) continue;
            attachments.remove((IMObject)attachment);
        }
        for (Reference ref : expectedInvoices) {
            FinancialAct invoice = (FinancialAct)IMObjectHelper.getObject((Reference)ref);
            if (invoice == null) continue;
            attachments.addInvoice(invoice);
        }
    }

    private void generate(Act attachment, Act claim, ClaimItemCollectionEditor items, Party insurer, Consumer<Boolean> listener) {
        IMObjectBean bean = this.service.getBean((IMObject)attachment);
        String type = bean.getString("type");
        if ("act.patientClinicalEvent".equals(type)) {
            this.generateHistory(claim, items, insurer, bean, listener);
        } else if (bean.getReference("document") == null) {
            Act original = (Act)bean.getTarget("original", Act.class);
            if (TypeHelper.isA((IMObject)original, (String)"act.customerAccountChargesInvoice")) {
                this.generateInvoice(bean, original, claim, listener);
            } else if (TypeHelper.isA((IMObject)original, (String)"act.patientInvestigation")) {
                this.generateInvestigation(bean, (DocumentAct)original, listener);
            } else if (original instanceof DocumentAct) {
                this.generateDocument(bean, original, listener);
            } else {
                this.noDocument(bean, original, listener);
            }
        } else {
            listener.accept(true);
        }
    }

    private void generateInvestigation(IMObjectBean bean, DocumentAct investigation, Consumer<Boolean> listener) {
        this.convertOrCopy(investigation.getDocument(), bean, (Act)investigation, listener);
    }

    private void generateDocument(IMObjectBean bean, Act original, Consumer<Boolean> listener) {
        Reference docRef;
        IMObjectBean source = this.service.getBean((IMObject)original);
        Reference reference = docRef = source.hasNode("document") ? source.getReference("document") : null;
        if (docRef == null) {
            if (original.isA(new String[]{"act.customerDocumentAttachment", "act.patientDocumentAttachment"})) {
                this.noDocument(bean, original, listener);
            } else {
                ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator((IMObject)original, this.context);
                Reporter reporter = this.factory.create((IMObject)original, (DocumentTemplateLocator)locator, TemplatedReporter.class);
                this.save(bean, (Reporter<Act>)reporter, listener);
            }
        } else {
            this.convertOrCopy(docRef, bean, original, listener);
        }
    }

    private void convertOrCopy(Reference docRef, IMObjectBean bean, Act original, Consumer<Boolean> listener) {
        org.openvpms.component.model.document.Document document;
        org.openvpms.component.model.document.Document document2 = document = docRef != null ? (org.openvpms.component.model.document.Document)this.service.get(docRef, org.openvpms.component.model.document.Document.class) : null;
        if (document == null) {
            this.noDocument(bean, original, listener);
        } else {
            String mimeType = document.getMimeType();
            if (!StringUtils.isEmpty((CharSequence)mimeType) && !"application/pdf".equals(mimeType)) {
                if (this.converter.canConvert(document, "application/pdf")) {
                    this.convertToPDF(bean, document, listener);
                } else {
                    this.copy(bean, document, listener);
                }
            } else {
                this.copy(bean, document, listener);
            }
        }
    }

    private void noDocument(IMObjectBean bean, Act original, Consumer<Boolean> listener) {
        String message = original != null ? Messages.format((String)"patient.insurance.nodocument", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)original, (ArchetypeService)this.service)}) : Messages.get((String)"patient.insurance.attachmentdeleted");
        this.setStatus(bean, Attachment.Status.ERROR, message);
        listener.accept(false);
    }

    private void convertToPDF(IMObjectBean bean, org.openvpms.component.model.document.Document document, Consumer<Boolean> listener) {
        Job job = JobBuilder.newJob((String)document.getName(), (User)this.context.getUser()).get(() -> this.converter.convert(document, "application/pdf", true)).completed(converted -> this.save(bean, (org.openvpms.component.model.document.Document)converted, listener)).cancelled(() -> listener.accept(false)).failed(exception -> {
            this.setStatus(bean, Attachment.Status.ERROR, exception.getMessage());
            listener.accept(false);
        }).build();
        this.rubJob((Job<org.openvpms.component.model.document.Document>)job, "document.convert.title", "document.convert.cancel");
    }

    private boolean isInvoice(Act attachment) {
        return "act.customerAccountChargesInvoice".equals(this.service.getBean((IMObject)attachment).getString("type"));
    }

    private void generateInvoice(IMObjectBean bean, Act original, Act claim, Consumer<Boolean> listener) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(INSURANCE_CLAIM_INVOICE, this.context);
        Reporter reporter = this.reporterFactory.create((IMObject)original, (DocumentTemplateLocator)locator, TemplatedReporter.class);
        reporter.getParameters().put("claim", claim);
        this.save(bean, (Reporter<Act>)reporter, listener);
    }

    private void generateHistory(Act claim, ClaimItemCollectionEditor items, Party insurer, IMObjectBean bean, Consumer<Boolean> listener) {
        PatientHistoryIterator history = this.getHistory(claim, items, insurer);
        if (!history.iterator().hasNext()) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("document.generateattachment.title", new Object[0])).messageKey("patient.insurance.nohistory", new Object[0])).yesNo()).yes(() -> this.generateHistory(history, bean, listener))).no(() -> listener.accept(false))).show();
        } else {
            this.generateHistory(history, bean, listener);
        }
    }

    private void generateHistory(PatientHistoryIterator history, IMObjectBean bean, Consumer<Boolean> listener) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(INSURANCE_CLAIM_MEDICAL_RECORDS, this.context);
        Reporter reporter = this.factory.create((Iterable)((Object)history), (DocumentTemplateLocator)locator, TemplatedReporter.class);
        this.save(bean, (Reporter<Act>)reporter, listener);
    }

    private void save(IMObjectBean bean, Reporter<Act> reporter, Consumer<Boolean> listener) {
        reporter.setFields(ReportContextFactory.create((Context)this.context));
        Job job = JobBuilder.newJob((String)"Claim Attachment Generator", (User)this.context.getUser()).get(() -> reporter.getDocument("application/pdf", true)).completed(document -> this.save(bean, (org.openvpms.component.model.document.Document)document, listener)).cancelled(() -> listener.accept(false)).failed(exception -> {
            this.setStatus(bean, Attachment.Status.ERROR, exception.getMessage());
            listener.accept(false);
        }).build();
        this.rubJob((Job<org.openvpms.component.model.document.Document>)job, "document.generateattachment.title", "document.generateattachment.cancel");
    }

    private void copy(IMObjectBean bean, org.openvpms.component.model.document.Document document, Consumer<Boolean> listener) {
        DocumentHandler handler = this.documentHandlers.get(document);
        InputStream content = handler.getContent(document);
        Document copy = handler.create(document.getName(), content, document.getMimeType(), document.getSize());
        this.save(bean, (org.openvpms.component.model.document.Document)copy, listener);
    }

    private void save(final IMObjectBean bean, final org.openvpms.component.model.document.Document document, Consumer<Boolean> listener) {
        boolean result = false;
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        try {
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    org.openvpms.component.model.document.Document existing = (org.openvpms.component.model.document.Document)bean.getObject("document", org.openvpms.component.model.document.Document.class);
                    if (existing != null) {
                        bean.setValue("document", null);
                        bean.save();
                        ClaimAttachmentGenerator.this.service.remove((IMObject)existing);
                    }
                    bean.setValue("status", (Object)Attachment.Status.PENDING.name());
                    bean.setValue("error", null);
                    bean.setValue("document", (Object)document.getObjectReference());
                    bean.setValue("fileName", (Object)document.getName());
                    bean.setValue("mimeType", (Object)document.getMimeType());
                    bean.save(new IMObject[]{document});
                }
            });
            result = true;
        }
        catch (Throwable exception) {
            this.setStatus(bean, Attachment.Status.ERROR, exception.getMessage());
        }
        listener.accept(result);
    }

    private void setStatus(IMObjectBean bean, Attachment.Status status, String message) {
        bean.setValue("status", (Object)status.name());
        if (message != null) {
            message = StringUtils.abbreviate((String)message, (int)255);
        }
        bean.setValue("error", (Object)message);
        bean.save();
    }

    private static class ClaimHistoryQuery
    extends PatientHistoryQuery {
        private final Date from;
        private final boolean inclusiveFrom;
        private final Date to;
        private final boolean inclusiveTo;

        public ClaimHistoryQuery(Party patient, Date from, boolean inclusiveFrom, Date to, boolean inclusiveTo) {
            super(patient, true);
            this.from = from;
            this.inclusiveFrom = inclusiveFrom;
            this.to = to;
            this.inclusiveTo = inclusiveTo;
        }

        @Override
        protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
            IConstraint times = this.createDateRangeConstraint();
            ParticipantConstraint[] participantConstraint = new ParticipantConstraint[]{this.getParticipantConstraint()};
            return new ActResultSet(this.getArchetypeConstraint(), participantConstraint, times, this.getStatuses(), this.excludeStatuses(), this.getConstraints(), this.getMaxResults(), sort);
        }

        private IConstraint createDateRangeConstraint() {
            Object result = this.from == null && this.to == null ? null : (this.from != null && this.to == null ? this.getFromConstraint() : (this.from == null ? this.getToConstraint() : Constraints.and((IConstraint[])new IConstraint[]{this.getFromConstraint(), this.getToConstraint()})));
            return result;
        }

        private NodeConstraint getFromConstraint() {
            return this.inclusiveFrom ? Constraints.gte((String)"startTime", (Object)this.from) : Constraints.gt((String)"startTime", (Object)this.from);
        }

        private IConstraint getToConstraint() {
            return this.inclusiveTo ? Constraints.lte((String)"startTime", (Object)this.to) : Constraints.lt((String)"startTime", (Object)this.to);
        }
    }
}

